/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.store.heap;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.shaded.org.ehcache.config.EvictionAdvisor;
import org.apache.hadoop.shaded.org.ehcache.core.spi.function.BiFunction;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.heap.Backend;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;

class SimpleBackend<K, V>
implements Backend<K, V> {
    private final ConcurrentHashMap<K, OnHeapValueHolder<V>> realMap;
    private final boolean byteSized;
    private final AtomicLong byteSize = new AtomicLong(0L);

    SimpleBackend(boolean byteSized) {
        this.byteSized = byteSized;
        this.realMap = new ConcurrentHashMap();
    }

    @Override
    public boolean remove(K key, OnHeapValueHolder<V> value) {
        return this.realMap.remove(key, value);
    }

    @Override
    public Map.Entry<K, OnHeapValueHolder<V>> getEvictionCandidate(Random random, int size, Comparator<? super Store.ValueHolder<V>> prioritizer, EvictionAdvisor<Object, ? super OnHeapValueHolder<?>> evictionAdvisor) {
        return this.realMap.getEvictionCandidate(random, size, prioritizer, evictionAdvisor);
    }

    @Override
    public long mappingCount() {
        return this.realMap.mappingCount();
    }

    @Override
    public long byteSize() {
        if (this.byteSized) {
            return this.byteSize.get();
        }
        throw new IllegalStateException("This store is not byte sized");
    }

    @Override
    public long naturalSize() {
        if (this.byteSized) {
            return this.byteSize.get();
        }
        return this.mappingCount();
    }

    @Override
    public void updateUsageInBytesIfRequired(long delta) {
        if (this.byteSized) {
            this.byteSize.addAndGet(delta);
        }
    }

    @Override
    public Iterable<K> keySet() {
        return this.realMap.keySet();
    }

    @Override
    public Iterator<Map.Entry<K, OnHeapValueHolder<V>>> entrySetIterator() {
        return this.realMap.entrySet().iterator();
    }

    @Override
    public OnHeapValueHolder<V> compute(K key, BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.realMap.compute(key, computeFunction);
    }

    @Override
    public Backend<K, V> clear() {
        return new SimpleBackend<K, V>(this.byteSized);
    }

    @Override
    public Map<K, OnHeapValueHolder<V>> removeAllWithHash(int hash) {
        Map<K, OnHeapValueHolder<V>> removed = this.realMap.removeAllWithHash(hash);
        if (this.byteSized) {
            long delta = 0L;
            for (Map.Entry<K, OnHeapValueHolder<V>> entry : removed.entrySet()) {
                delta -= entry.getValue().size();
            }
            this.updateUsageInBytesIfRequired(delta);
        }
        return removed;
    }

    @Override
    public OnHeapValueHolder<V> remove(K key) {
        return this.realMap.remove(key);
    }

    @Override
    public OnHeapValueHolder<V> computeIfPresent(K key, BiFunction<K, OnHeapValueHolder<V>, OnHeapValueHolder<V>> computeFunction) {
        return this.realMap.computeIfPresent(key, computeFunction);
    }

    @Override
    public OnHeapValueHolder<V> get(K key) {
        return this.realMap.get(key);
    }

    @Override
    public OnHeapValueHolder<V> putIfAbsent(K key, OnHeapValueHolder<V> valueHolder) {
        return this.realMap.putIfAbsent(key, valueHolder);
    }

    @Override
    public boolean replace(K key, OnHeapValueHolder<V> oldValue, OnHeapValueHolder<V> newValue) {
        return this.realMap.replace(key, oldValue, newValue);
    }
}

