/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.shaded.org.ehcache.Cache;
import org.apache.hadoop.shaded.org.ehcache.CachePersistenceException;
import org.apache.hadoop.shaded.org.ehcache.PersistentUserManagedCache;
import org.apache.hadoop.shaded.org.ehcache.Status;
import org.apache.hadoop.shaded.org.ehcache.config.CacheConfiguration;
import org.apache.hadoop.shaded.org.ehcache.config.CacheRuntimeConfiguration;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.core.Ehcache;
import org.apache.hadoop.shaded.org.ehcache.core.EhcacheRuntimeConfiguration;
import org.apache.hadoop.shaded.org.ehcache.core.EhcacheWithLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.core.InternalCache;
import org.apache.hadoop.shaded.org.ehcache.core.StatusTransitioner;
import org.apache.hadoop.shaded.org.ehcache.core.events.CacheEventDispatcher;
import org.apache.hadoop.shaded.org.ehcache.core.spi.LifeCycled;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.DiskResourceService;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheWritingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentUserManagedEhcache<K, V>
implements PersistentUserManagedCache<K, V> {
    private final StatusTransitioner statusTransitioner;
    private final Logger logger;
    private final InternalCache<K, V> cache;
    private final DiskResourceService diskPersistenceService;
    private final String id;

    public PersistentUserManagedEhcache(CacheConfiguration<K, V> configuration, Store<K, V> store, DiskResourceService diskPersistenceService, CacheLoaderWriter<? super K, V> cacheLoaderWriter, CacheEventDispatcher<K, V> eventDispatcher, String id) {
        this.logger = LoggerFactory.getLogger((String)(PersistentUserManagedEhcache.class.getName() + "-" + id));
        this.statusTransitioner = new StatusTransitioner(this.logger);
        this.cache = cacheLoaderWriter == null ? new Ehcache<K, V>(new EhcacheRuntimeConfiguration<K, V>(configuration), store, eventDispatcher, this.logger, this.statusTransitioner) : new EhcacheWithLoaderWriter<K, V>(new EhcacheRuntimeConfiguration<K, V>(configuration), store, cacheLoaderWriter, eventDispatcher, true, this.logger, this.statusTransitioner);
        this.diskPersistenceService = diskPersistenceService;
        this.id = id;
    }

    @Override
    public void destroy() throws CachePersistenceException {
        StatusTransitioner.Transition st = this.statusTransitioner.maintenance();
        try {
            st.succeeded();
        }
        catch (Throwable t) {
            throw st.failed(t);
        }
        this.destroyInternal();
    }

    void create() {
        this.statusTransitioner.checkMaintenance();
        try {
            if (!this.getRuntimeConfiguration().getResourcePools().getPoolForResource(ResourceType.Core.DISK).isPersistent()) {
                this.destroy();
            }
            this.diskPersistenceService.getPersistenceSpaceIdentifier(this.id, this.cache.getRuntimeConfiguration());
        }
        catch (CachePersistenceException e) {
            throw new RuntimeException("Unable to create persistence space for user managed cache " + this.id, e);
        }
    }

    void destroyInternal() throws CachePersistenceException {
        this.statusTransitioner.checkMaintenance();
        this.diskPersistenceService.destroy(this.id);
    }

    @Override
    public void init() {
        this.cache.init();
    }

    @Override
    public void close() {
        this.cache.close();
        if (!this.getRuntimeConfiguration().getResourcePools().getPoolForResource(ResourceType.Core.DISK).isPersistent()) {
            try {
                this.diskPersistenceService.destroy(this.id);
            }
            catch (CachePersistenceException e) {
                this.logger.debug("Unable to clear persistence space for user managed cache {}", (Object)this.id, (Object)e);
            }
        }
    }

    @Override
    public Status getStatus() {
        return this.statusTransitioner.currentStatus();
    }

    @Override
    public V get(K key) throws CacheLoadingException {
        return this.cache.get(key);
    }

    @Override
    public void put(K key, V value) throws CacheWritingException {
        this.cache.put(key, value);
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void remove(K key) throws CacheWritingException {
        this.cache.remove(key);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws BulkCacheLoadingException {
        return this.cache.getAll(keys);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) throws BulkCacheWritingException {
        this.cache.putAll(entries);
    }

    @Override
    public void removeAll(Set<? extends K> keys) throws BulkCacheWritingException {
        this.cache.removeAll(keys);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public V putIfAbsent(K key, V value) throws CacheLoadingException, CacheWritingException {
        return this.cache.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(K key, V value) throws CacheWritingException {
        return this.cache.remove(key, value);
    }

    @Override
    public V replace(K key, V value) throws CacheLoadingException, CacheWritingException {
        return this.cache.replace(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) throws CacheLoadingException, CacheWritingException {
        return this.cache.replace(key, oldValue, newValue);
    }

    @Override
    public CacheRuntimeConfiguration<K, V> getRuntimeConfiguration() {
        return this.cache.getRuntimeConfiguration();
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        return this.cache.iterator();
    }

    public void addHook(LifeCycled lifeCycled) {
        this.statusTransitioner.addHook(lifeCycled);
    }
}

