/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

class PendingRecoveryBlocks {
    private static final Logger LOG = BlockManager.LOG;
    private final LightWeightHashSet<BlockRecoveryAttempt> recoveryTimeouts = new LightWeightHashSet();
    private long recoveryTimeoutInterval;

    PendingRecoveryBlocks(long timeout) {
        this.recoveryTimeoutInterval = timeout;
    }

    synchronized void remove(BlockInfo block) {
        this.recoveryTimeouts.remove(new BlockRecoveryAttempt(block));
    }

    synchronized boolean add(BlockInfo block) {
        boolean added = false;
        long curTime = this.getTime();
        BlockRecoveryAttempt recoveryAttempt = this.recoveryTimeouts.getElement(new BlockRecoveryAttempt(block));
        if (recoveryAttempt == null) {
            BlockRecoveryAttempt newAttempt = new BlockRecoveryAttempt(block, curTime + this.recoveryTimeoutInterval);
            added = this.recoveryTimeouts.add(newAttempt);
        } else if (recoveryAttempt.hasTimedOut(curTime)) {
            recoveryAttempt.setTimeout(curTime + this.recoveryTimeoutInterval);
            added = true;
        } else {
            long timeoutIn = TimeUnit.MILLISECONDS.toSeconds(recoveryAttempt.timeoutAt - curTime);
            LOG.info("Block recovery attempt for " + (Object)((Object)block) + " rejected, as the previous attempt times out in " + timeoutIn + " seconds.");
        }
        return added;
    }

    synchronized boolean isUnderRecovery(BlockInfo b) {
        BlockRecoveryAttempt recoveryAttempt = this.recoveryTimeouts.getElement(new BlockRecoveryAttempt(b));
        return recoveryAttempt != null;
    }

    long getTime() {
        return Time.monotonicNow();
    }

    @VisibleForTesting
    synchronized void setRecoveryTimeoutInterval(long recoveryTimeoutInterval) {
        this.recoveryTimeoutInterval = recoveryTimeoutInterval;
    }

    private static class BlockRecoveryAttempt {
        private final BlockInfo blockInfo;
        private long timeoutAt;

        private BlockRecoveryAttempt(BlockInfo blockInfo) {
            this(blockInfo, 0L);
        }

        BlockRecoveryAttempt(BlockInfo blockInfo, long timeoutAt) {
            this.blockInfo = blockInfo;
            this.timeoutAt = timeoutAt;
        }

        boolean hasTimedOut(long currentTime) {
            return currentTime > this.timeoutAt;
        }

        void setTimeout(long newTimeoutAt) {
            this.timeoutAt = newTimeoutAt;
        }

        public int hashCode() {
            return this.blockInfo.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockRecoveryAttempt) {
                return this.blockInfo.equals((Object)((BlockRecoveryAttempt)obj).blockInfo);
            }
            return false;
        }
    }
}

