/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStatistics;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStats;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.StorageTypeStats;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StopWatch;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatManager
implements DatanodeStatistics {
    static final Logger LOG = LoggerFactory.getLogger(HeartbeatManager.class);
    private final List<DatanodeDescriptor> datanodes = new ArrayList<DatanodeDescriptor>();
    private final DatanodeStats stats = new DatanodeStats();
    private final long heartbeatRecheckInterval;
    private final Daemon heartbeatThread = new Daemon((Runnable)new Monitor());
    private final StopWatch heartbeatStopWatch = new StopWatch();
    final Namesystem namesystem;
    final BlockManager blockManager;

    HeartbeatManager(Namesystem namesystem, BlockManager blockManager, Configuration conf) {
        this.namesystem = namesystem;
        this.blockManager = blockManager;
        boolean avoidStaleDataNodesForWrite = conf.getBoolean("dfs.namenode.avoid.write.stale.datanode", false);
        long recheckInterval = conf.getInt("dfs.namenode.heartbeat.recheck-interval", 300000);
        long staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
        if (avoidStaleDataNodesForWrite && staleInterval < recheckInterval) {
            this.heartbeatRecheckInterval = staleInterval;
            LOG.info("Setting heartbeat recheck interval to " + staleInterval + " since " + "dfs.namenode.stale.datanode.interval" + " is less than " + "dfs.namenode.heartbeat.recheck-interval");
        } else {
            this.heartbeatRecheckInterval = recheckInterval;
        }
    }

    void activate() {
        this.heartbeatThread.start();
    }

    void close() {
        this.heartbeatThread.interrupt();
        try {
            this.heartbeatThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized int getLiveDatanodeCount() {
        return this.datanodes.size();
    }

    @Override
    public long getCapacityTotal() {
        return this.stats.getCapacityTotal();
    }

    @Override
    public long getCapacityUsed() {
        return this.stats.getCapacityUsed();
    }

    @Override
    public float getCapacityUsedPercent() {
        return this.stats.getCapacityUsedPercent();
    }

    @Override
    public long getCapacityRemaining() {
        return this.stats.getCapacityRemaining();
    }

    @Override
    public float getCapacityRemainingPercent() {
        return this.stats.getCapacityRemainingPercent();
    }

    @Override
    public long getBlockPoolUsed() {
        return this.stats.getBlockPoolUsed();
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return this.stats.getPercentBlockPoolUsed();
    }

    @Override
    public long getCapacityUsedNonDFS() {
        return this.stats.getCapacityUsedNonDFS();
    }

    @Override
    public int getXceiverCount() {
        return this.stats.getXceiverCount();
    }

    @Override
    public int getInServiceXceiverCount() {
        return this.stats.getNodesInServiceXceiverCount();
    }

    @Override
    public int getNumDatanodesInService() {
        return this.stats.getNodesInService();
    }

    @Override
    public long getCacheCapacity() {
        return this.stats.getCacheCapacity();
    }

    @Override
    public long getCacheUsed() {
        return this.stats.getCacheUsed();
    }

    @Override
    public synchronized long[] getStats() {
        return new long[]{this.getCapacityTotal(), this.getCapacityUsed(), this.getCapacityRemaining(), -1L, -1L, -1L, -1L, -1L, -1L};
    }

    @Override
    public int getExpiredHeartbeats() {
        return this.stats.getExpiredHeartbeats();
    }

    @Override
    public Map<StorageType, StorageTypeStats> getStorageTypeStats() {
        return this.stats.getStatsMap();
    }

    @Override
    public long getProvidedCapacity() {
        return this.blockManager.getProvidedCapacity();
    }

    synchronized void register(DatanodeDescriptor d) {
        if (!d.isAlive()) {
            this.addDatanode(d);
            d.updateHeartbeatState(StorageReport.EMPTY_ARRAY, 0L, 0L, 0, 0, null);
            this.stats.add(d);
        }
    }

    synchronized DatanodeDescriptor[] getDatanodes() {
        return this.datanodes.toArray(new DatanodeDescriptor[this.datanodes.size()]);
    }

    synchronized void addDatanode(DatanodeDescriptor d) {
        this.datanodes.add(d);
        d.setAlive(true);
    }

    void updateDnStat(DatanodeDescriptor d) {
        this.stats.add(d);
    }

    synchronized void removeDatanode(DatanodeDescriptor node) {
        if (node.isAlive()) {
            this.stats.subtract(node);
            this.datanodes.remove((Object)node);
            node.setAlive(false);
        }
    }

    synchronized void updateHeartbeat(DatanodeDescriptor node, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) {
        this.stats.subtract(node);
        this.blockManager.updateHeartbeat(node, reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
        this.stats.add(node);
    }

    synchronized void updateLifeline(DatanodeDescriptor node, StorageReport[] reports, long cacheCapacity, long cacheUsed, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) {
        this.stats.subtract(node);
        node.updateHeartbeatState(reports, cacheCapacity, cacheUsed, xceiverCount, failedVolumes, volumeFailureSummary);
        this.stats.add(node);
    }

    synchronized void startDecommission(DatanodeDescriptor node) {
        if (!node.isAlive()) {
            LOG.info("Dead node {} is decommissioned immediately.", (Object)node);
            node.setDecommissioned();
        } else {
            this.stats.subtract(node);
            node.startDecommission();
            this.stats.add(node);
        }
    }

    synchronized void startMaintenance(DatanodeDescriptor node) {
        if (!node.isAlive()) {
            LOG.info("Dead node {} is put in maintenance state immediately.", (Object)node);
            node.setInMaintenance();
        } else {
            this.stats.subtract(node);
            if (node.isDecommissioned()) {
                LOG.info("Decommissioned node " + (Object)((Object)node) + " is put in maintenance state immediately.");
                node.setInMaintenance();
            } else if (this.blockManager.getMinReplicationToBeInMaintenance() == 0) {
                LOG.info("MinReplicationToBeInMaintenance is set to zero. " + (Object)((Object)node) + " is put in maintenance state immediately.");
                node.setInMaintenance();
            } else {
                node.startMaintenance();
            }
            this.stats.add(node);
        }
    }

    synchronized void stopMaintenance(DatanodeDescriptor node) {
        LOG.info("Stopping maintenance of {} node {}", (Object)(node.isAlive() ? "live" : "dead"), (Object)node);
        if (!node.isAlive()) {
            node.stopMaintenance();
        } else {
            this.stats.subtract(node);
            node.stopMaintenance();
            this.stats.add(node);
        }
    }

    synchronized void stopDecommission(DatanodeDescriptor node) {
        LOG.info("Stopping decommissioning of {} node {}", (Object)(node.isAlive() ? "live" : "dead"), (Object)node);
        if (!node.isAlive()) {
            node.stopDecommission();
        } else {
            this.stats.subtract(node);
            node.stopDecommission();
            this.stats.add(node);
        }
    }

    @VisibleForTesting
    void restartHeartbeatStopWatch() {
        this.heartbeatStopWatch.reset().start();
    }

    @VisibleForTesting
    boolean shouldAbortHeartbeatCheck(long offset) {
        long elapsed = this.heartbeatStopWatch.now(TimeUnit.MILLISECONDS);
        return elapsed + offset > this.heartbeatRecheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void heartbeatCheck() {
        DatanodeManager dm = this.blockManager.getDatanodeManager();
        if (this.namesystem.isInStartupSafeMode()) {
            return;
        }
        boolean allAlive = false;
        while (!allAlive) {
            DatanodeDescriptor dead = null;
            DatanodeStorageInfo failedStorage = null;
            int numOfStaleNodes = 0;
            int numOfStaleStorages = 0;
            HeartbeatManager heartbeatManager = this;
            synchronized (heartbeatManager) {
                for (DatanodeDescriptor d : this.datanodes) {
                    DatanodeStorageInfo[] storageInfos;
                    if (this.shouldAbortHeartbeatCheck(0L)) {
                        return;
                    }
                    if (dead == null && dm.isDatanodeDead(d)) {
                        this.stats.incrExpiredHeartbeats();
                        dead = d;
                    }
                    if (d.isStale(dm.getStaleInterval())) {
                        ++numOfStaleNodes;
                    }
                    for (DatanodeStorageInfo storageInfo : storageInfos = d.getStorageInfos()) {
                        if (storageInfo.areBlockContentsStale()) {
                            ++numOfStaleStorages;
                        }
                        if (failedStorage != null || !storageInfo.areBlocksOnFailedStorage() || d == dead) continue;
                        failedStorage = storageInfo;
                    }
                }
                dm.setNumStaleNodes(numOfStaleNodes);
                dm.setNumStaleStorages(numOfStaleStorages);
            }
            boolean bl = allAlive = dead == null && failedStorage == null;
            if (!allAlive && this.namesystem.isInStartupSafeMode()) {
                return;
            }
            if (dead != null) {
                this.namesystem.writeLock();
                try {
                    dm.removeDeadDatanode((DatanodeID)dead, !dead.isMaintenance());
                }
                finally {
                    this.namesystem.writeUnlock();
                }
            }
            if (failedStorage == null) continue;
            this.namesystem.writeLock();
            try {
                this.blockManager.removeBlocksAssociatedTo(failedStorage);
            }
            finally {
                this.namesystem.writeUnlock();
            }
        }
    }

    private class Monitor
    implements Runnable {
        private long lastHeartbeatCheck;
        private long lastBlockKeyUpdate;

        private Monitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (HeartbeatManager.this.namesystem.isRunning()) {
                block10: {
                    HeartbeatManager.this.restartHeartbeatStopWatch();
                    try {
                        long now = Time.monotonicNow();
                        if (this.lastHeartbeatCheck + HeartbeatManager.this.heartbeatRecheckInterval < now) {
                            HeartbeatManager.this.heartbeatCheck();
                            this.lastHeartbeatCheck = now;
                        }
                        if (!HeartbeatManager.this.blockManager.shouldUpdateBlockKey(now - this.lastBlockKeyUpdate)) break block10;
                        HeartbeatManager heartbeatManager = HeartbeatManager.this;
                        synchronized (heartbeatManager) {
                            for (DatanodeDescriptor d : HeartbeatManager.this.datanodes) {
                                d.setNeedKeyUpdate(true);
                            }
                        }
                        this.lastBlockKeyUpdate = now;
                    }
                    catch (Exception e) {
                        LOG.error("Exception while checking heartbeat", (Throwable)e);
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!HeartbeatManager.this.shouldAbortHeartbeatCheck(-5000L)) continue;
                LOG.warn("Skipping next heartbeat scan due to excessive pause");
                this.lastHeartbeatCheck = Time.monotonicNow();
            }
        }
    }
}

