/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.utils;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class AMRMClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMClientUtils.class);
    public static final String APP_ALREADY_REGISTERED_MESSAGE = "Application Master is already registered : ";

    private AMRMClientUtils() {
    }

    public static void handleNotRegisteredExceptionAndReRegister(ApplicationId appId, ApplicationMasterProtocol rmProxy, RegisterApplicationMasterRequest registerRequest) throws YarnException {
        LOG.info("App attempt {} not registered, most likely due to RM failover.  Trying to re-register.", (Object)appId);
        try {
            rmProxy.registerApplicationMaster(registerRequest);
        }
        catch (Exception e) {
            if (e instanceof InvalidApplicationMasterRequestException && e.getMessage().contains(APP_ALREADY_REGISTERED_MESSAGE)) {
                LOG.info("Concurrent thread successfully registered, moving on.");
            }
            LOG.error("Error trying to re-register AM", (Throwable)e);
            throw new YarnException((Throwable)e);
        }
    }

    public static AllocateResponse allocateWithReRegister(AllocateRequest request, ApplicationMasterProtocol rmProxy, RegisterApplicationMasterRequest registerRequest, ApplicationId appId) throws YarnException, IOException {
        try {
            return rmProxy.allocate(request);
        }
        catch (ApplicationMasterNotRegisteredException e) {
            AMRMClientUtils.handleNotRegisteredExceptionAndReRegister(appId, rmProxy, registerRequest);
            request.setResponseId(0);
            return AMRMClientUtils.allocateWithReRegister(request, rmProxy, registerRequest, appId);
        }
    }

    public static FinishApplicationMasterResponse finishAMWithReRegister(FinishApplicationMasterRequest request, ApplicationMasterProtocol rmProxy, RegisterApplicationMasterRequest registerRequest, ApplicationId appId) throws YarnException, IOException {
        try {
            return rmProxy.finishApplicationMaster(request);
        }
        catch (ApplicationMasterNotRegisteredException ex) {
            AMRMClientUtils.handleNotRegisteredExceptionAndReRegister(appId, rmProxy, registerRequest);
            return AMRMClientUtils.finishAMWithReRegister(request, rmProxy, registerRequest, appId);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static <T> T createRMProxy(final Configuration configuration, final Class<T> protocol, UserGroupInformation user, Token<? extends TokenIdentifier> token) throws IOException {
        try {
            String rmClusterId = configuration.get("yarn.resourcemanager.cluster-id", "yarn_cluster");
            LOG.info("Creating RMProxy to RM {} for protocol {} for user {}", new Object[]{rmClusterId, protocol.getSimpleName(), user});
            if (token != null) {
                user.addToken(token);
                token.setService(ClientRMProxy.getAMRMTokenService((Configuration)configuration));
                AMRMClientUtils.setAuthModeInConf(configuration);
            }
            Object proxyConnection = user.doAs(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return ClientRMProxy.createRMProxy((Configuration)configuration, (Class)protocol);
                }
            });
            return (T)proxyConnection;
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    private static void setAuthModeInConf(Configuration conf) {
        conf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
    }
}

