/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeFilter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
public class ClusterNodeTracker<N extends SchedulerNode> {
    private static final Log LOG = LogFactory.getLog(ClusterNodeTracker.class);
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private Lock readLock = this.readWriteLock.readLock();
    private Lock writeLock = this.readWriteLock.writeLock();
    private HashMap<NodeId, N> nodes = new HashMap();
    private Map<String, N> nodeNameToNodeMap = new HashMap<String, N>();
    private Map<String, List<N>> nodesPerRack = new HashMap<String, List<N>>();
    private Resource clusterCapacity = Resources.createResource((int)0, (int)0);
    private volatile Resource staleClusterCapacity = Resources.clone((Resource)Resources.none());
    private final long[] maxAllocation = new long[ResourceUtils.getNumberOfKnownResourceTypes()];
    private Resource configuredMaxAllocation;
    private boolean forceConfiguredMaxAllocation = true;
    private long configuredMaxAllocationWaitTime;
    private boolean reportedMaxAllocation = false;

    public ClusterNodeTracker() {
        Arrays.fill(this.maxAllocation, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(N node) {
        this.writeLock.lock();
        try {
            this.nodes.put(((SchedulerNode)node).getNodeID(), node);
            this.nodeNameToNodeMap.put(((SchedulerNode)node).getNodeName(), node);
            String rackName = ((SchedulerNode)node).getRackName();
            List<N> nodesList = this.nodesPerRack.get(rackName);
            if (nodesList == null) {
                nodesList = new ArrayList<N>();
                this.nodesPerRack.put(rackName, nodesList);
            }
            nodesList.add(node);
            Resources.addTo((Resource)this.clusterCapacity, (Resource)((SchedulerNode)node).getTotalResource());
            this.staleClusterCapacity = Resources.clone((Resource)this.clusterCapacity);
            this.updateMaxResources((SchedulerNode)node, true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean exists(NodeId nodeId) {
        this.readLock.lock();
        try {
            boolean bl = this.nodes.containsKey(nodeId);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public N getNode(NodeId nodeId) {
        this.readLock.lock();
        try {
            SchedulerNode schedulerNode = (SchedulerNode)this.nodes.get(nodeId);
            return (N)schedulerNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        this.readLock.lock();
        try {
            SchedulerNode n = (SchedulerNode)this.nodes.get(nodeId);
            SchedulerNodeReport schedulerNodeReport = n == null ? null : new SchedulerNodeReport(n);
            return schedulerNodeReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int nodeCount() {
        this.readLock.lock();
        try {
            int n = this.nodes.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nodeCount(String rackName) {
        this.readLock.lock();
        String rName = rackName == null ? "NULL" : rackName;
        try {
            List<N> nodesList = this.nodesPerRack.get(rName);
            int n = nodesList == null ? 0 : nodesList.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getClusterCapacity() {
        return this.staleClusterCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N removeNode(NodeId nodeId) {
        this.writeLock.lock();
        try {
            SchedulerNode node = (SchedulerNode)this.nodes.remove(nodeId);
            if (node == null) {
                LOG.warn((Object)("Attempting to remove a non-existent node " + nodeId));
                N n = null;
                return n;
            }
            this.nodeNameToNodeMap.remove(node.getNodeName());
            String rackName = node.getRackName();
            List<N> nodesList = this.nodesPerRack.get(rackName);
            if (nodesList == null) {
                LOG.error((Object)("Attempting to remove node from an empty rack " + rackName));
            } else {
                nodesList.remove(node);
                if (nodesList.isEmpty()) {
                    this.nodesPerRack.remove(rackName);
                }
            }
            Resources.subtractFrom((Resource)this.clusterCapacity, (Resource)node.getTotalResource());
            this.staleClusterCapacity = Resources.clone((Resource)this.clusterCapacity);
            this.updateMaxResources(node, false);
            SchedulerNode schedulerNode = node;
            return (N)schedulerNode;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setConfiguredMaxAllocation(Resource resource) {
        this.writeLock.lock();
        try {
            this.configuredMaxAllocation = Resources.clone((Resource)resource);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setConfiguredMaxAllocationWaitTime(long configuredMaxAllocationWaitTime) {
        this.writeLock.lock();
        try {
            this.configuredMaxAllocationWaitTime = configuredMaxAllocationWaitTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getMaxAllowedAllocation() {
        this.readLock.lock();
        try {
            if (this.forceConfiguredMaxAllocation && System.currentTimeMillis() - ResourceManager.getClusterTimeStamp() > this.configuredMaxAllocationWaitTime) {
                this.forceConfiguredMaxAllocation = false;
            }
            if (this.forceConfiguredMaxAllocation || !this.reportedMaxAllocation) {
                Resource resource = this.configuredMaxAllocation;
                return resource;
            }
            Resource ret = Resources.clone((Resource)this.configuredMaxAllocation);
            for (int i = 0; i < this.maxAllocation.length; ++i) {
                ResourceInformation info = ret.getResourceInformation(i);
                if (info.getValue() <= this.maxAllocation[i]) continue;
                info.setValue(this.maxAllocation[i]);
            }
            Resource resource = ret;
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxResources(SchedulerNode node, boolean add) {
        Resource totalResource = node.getTotalResource();
        if (totalResource == null) {
            LOG.warn((Object)(node.getNodeName() + " reported in with null resources, which " + "indicates a problem in the source code. Please file an issue at " + "https://issues.apache.org/jira/secure/CreateIssue!default.jspa"));
            return;
        }
        ResourceInformation[] totalResources = totalResource.getResources();
        this.writeLock.lock();
        try {
            if (add) {
                this.reportedMaxAllocation = true;
                for (int i = 0; i < this.maxAllocation.length; ++i) {
                    long value = totalResources[i].getValue();
                    if (value <= this.maxAllocation[i]) continue;
                    this.maxAllocation[i] = value;
                }
            } else {
                boolean recalculate = false;
                for (int i = 0; i < this.maxAllocation.length; ++i) {
                    if (totalResources[i].getValue() != this.maxAllocation[i]) continue;
                    this.maxAllocation[i] = -1L;
                    recalculate = true;
                }
                if (recalculate) {
                    this.reportedMaxAllocation = false;
                    this.nodes.values().forEach(n -> this.updateMaxResources((SchedulerNode)n, true));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<N> getAllNodes() {
        return this.getNodes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<N> getNodes(NodeFilter nodeFilter) {
        ArrayList<Object> nodeList = new ArrayList<Object>();
        this.readLock.lock();
        try {
            if (nodeFilter == null) {
                nodeList.addAll(this.nodes.values());
            } else {
                for (SchedulerNode node : this.nodes.values()) {
                    if (!nodeFilter.accept(node)) continue;
                    nodeList.add(node);
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return nodeList;
    }

    public List<NodeId> getAllNodeIds() {
        return this.getNodeIds(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeId> getNodeIds(NodeFilter nodeFilter) {
        ArrayList<NodeId> nodeList = new ArrayList<NodeId>();
        this.readLock.lock();
        try {
            if (nodeFilter == null) {
                for (SchedulerNode node : this.nodes.values()) {
                    nodeList.add(node.getNodeID());
                }
            } else {
                for (SchedulerNode node : this.nodes.values()) {
                    if (!nodeFilter.accept(node)) continue;
                    nodeList.add(node.getNodeID());
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return nodeList;
    }

    public List<N> sortedNodeList(Comparator<N> comparator) {
        ArrayList<N> sortedList = null;
        this.readLock.lock();
        try {
            sortedList = new ArrayList<N>(this.nodes.values());
        }
        finally {
            this.readLock.unlock();
        }
        Collections.sort(sortedList, comparator);
        return sortedList;
    }

    public List<N> getNodesByResourceName(String resourceName) {
        Preconditions.checkArgument((resourceName != null && !resourceName.isEmpty() ? 1 : 0) != 0);
        ArrayList<N> retNodes = new ArrayList<N>();
        if ("*".equals(resourceName)) {
            retNodes.addAll(this.getAllNodes());
        } else if (this.nodeNameToNodeMap.containsKey(resourceName)) {
            retNodes.add(this.nodeNameToNodeMap.get(resourceName));
        } else if (this.nodesPerRack.containsKey(resourceName)) {
            retNodes.addAll((Collection)this.nodesPerRack.get(resourceName));
        } else {
            LOG.info((Object)("Could not find a node matching given resourceName " + resourceName));
        }
        return retNodes;
    }

    public List<NodeId> getNodeIdsByResourceName(String resourceName) {
        Preconditions.checkArgument((resourceName != null && !resourceName.isEmpty() ? 1 : 0) != 0);
        ArrayList<NodeId> retNodes = new ArrayList<NodeId>();
        if ("*".equals(resourceName)) {
            retNodes.addAll(this.getAllNodeIds());
        } else if (this.nodeNameToNodeMap.containsKey(resourceName)) {
            retNodes.add(((SchedulerNode)this.nodeNameToNodeMap.get(resourceName)).getNodeID());
        } else if (this.nodesPerRack.containsKey(resourceName)) {
            for (SchedulerNode node : this.nodesPerRack.get(resourceName)) {
                retNodes.add(node.getNodeID());
            }
        } else {
            LOG.info((Object)("Could not find a node matching given resourceName " + resourceName));
        }
        return retNodes;
    }
}

