/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.shaded.org.mockito.InOrder;
import org.apache.hadoop.shaded.org.mockito.MockSettings;
import org.apache.hadoop.shaded.org.mockito.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.exceptions.misusing.NotAMockException;
import org.apache.hadoop.shaded.org.mockito.internal.InOrderImpl;
import org.apache.hadoop.shaded.org.mockito.internal.MockHandlerInterface;
import org.apache.hadoop.shaded.org.mockito.internal.creation.MockSettingsImpl;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.AllInvocationsFinder;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.internal.progress.IOngoingStubbing;
import org.apache.hadoop.shaded.org.mockito.internal.progress.MockingProgress;
import org.apache.hadoop.shaded.org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.InvocationContainer;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.apache.hadoop.shaded.org.mockito.internal.stubbing.StubberImpl;
import org.apache.hadoop.shaded.org.mockito.internal.util.MockUtil;
import org.apache.hadoop.shaded.org.mockito.internal.verification.MockAwareVerificationMode;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationDataImpl;
import org.apache.hadoop.shaded.org.mockito.internal.verification.VerificationModeFactory;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.InOrderContext;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.VerificationDataInOrderImpl;
import org.apache.hadoop.shaded.org.mockito.stubbing.Answer;
import org.apache.hadoop.shaded.org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.apache.hadoop.shaded.org.mockito.stubbing.OngoingStubbing;
import org.apache.hadoop.shaded.org.mockito.stubbing.Stubber;
import org.apache.hadoop.shaded.org.mockito.stubbing.VoidMethodStubbable;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoCore {
    private final Reporter reporter = new Reporter();
    private final MockUtil mockUtil = new MockUtil();
    private final MockingProgress mockingProgress = new ThreadSafeMockingProgress();

    public <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        T mock = this.mockUtil.createMock(classToMock, (MockSettingsImpl)mockSettings);
        this.mockingProgress.mockingStarted(mock, classToMock, mockSettings);
        return mock;
    }

    public IOngoingStubbing stub() {
        IOngoingStubbing stubbing = this.mockingProgress.pullOngoingStubbing();
        if (stubbing == null) {
            this.mockingProgress.reset();
            this.reporter.missingMethodInvocation();
        }
        return stubbing;
    }

    public <T> DeprecatedOngoingStubbing<T> stub(T methodCall) {
        this.mockingProgress.stubbingStarted();
        return (DeprecatedOngoingStubbing)this.stub();
    }

    public <T> OngoingStubbing<T> when(T methodCall) {
        this.mockingProgress.stubbingStarted();
        return (OngoingStubbing)this.stub();
    }

    public <T> T verify(T mock, VerificationMode mode) {
        if (mock == null) {
            this.reporter.nullPassedToVerify();
        } else if (!this.mockUtil.isMock(mock)) {
            this.reporter.notAMockPassedToVerify();
        }
        this.mockingProgress.verificationStarted(new MockAwareVerificationMode(mock, mode));
        return mock;
    }

    public <T> void reset(T ... mocks) {
        this.mockingProgress.validateState();
        this.mockingProgress.reset();
        this.mockingProgress.resetOngoingStubbing();
        for (T m : mocks) {
            this.mockUtil.resetMock(m);
        }
    }

    public void verifyNoMoreInteractions(Object ... mocks) {
        this.assertMocksNotEmpty(mocks);
        this.mockingProgress.validateState();
        for (Object mock : mocks) {
            try {
                if (mock == null) {
                    this.reporter.nullPassedToVerifyNoMoreInteractions();
                }
                InvocationContainer invocations = this.mockUtil.getMockHandler(mock).getInvocationContainer();
                VerificationDataImpl data = new VerificationDataImpl(invocations, null);
                VerificationModeFactory.noMoreInteractions().verify(data);
            }
            catch (NotAMockException e) {
                this.reporter.notAMockPassedToVerifyNoMoreInteractions();
            }
        }
    }

    public void verifyNoMoreInteractionsInOrder(List<Object> mocks, InOrderContext inOrderContext) {
        this.mockingProgress.validateState();
        AllInvocationsFinder finder = new AllInvocationsFinder();
        VerificationDataInOrderImpl data = new VerificationDataInOrderImpl(inOrderContext, finder.find(mocks), null);
        VerificationModeFactory.noMoreInteractions().verifyInOrder(data);
    }

    private void assertMocksNotEmpty(Object[] mocks) {
        if (mocks == null || mocks.length == 0) {
            this.reporter.mocksHaveToBePassedToVerifyNoMoreInteractions();
        }
    }

    public InOrder inOrder(Object ... mocks) {
        if (mocks == null || mocks.length == 0) {
            this.reporter.mocksHaveToBePassedWhenCreatingInOrder();
        }
        for (Object mock : mocks) {
            if (mock == null) {
                this.reporter.nullPassedWhenCreatingInOrder();
                continue;
            }
            if (this.mockUtil.isMock(mock)) continue;
            this.reporter.notAMockPassedWhenCreatingInOrder();
        }
        return new InOrderImpl(Arrays.asList(mocks));
    }

    public Stubber doAnswer(Answer answer) {
        this.mockingProgress.stubbingStarted();
        this.mockingProgress.resetOngoingStubbing();
        return new StubberImpl().doAnswer(answer);
    }

    public <T> VoidMethodStubbable<T> stubVoid(T mock) {
        MockHandlerInterface<T> handler = this.mockUtil.getMockHandler(mock);
        this.mockingProgress.stubbingStarted();
        return handler.voidMethodStubbable(mock);
    }

    public void validateMockitoUsage() {
        this.mockingProgress.validateState();
    }

    public Invocation getLastInvocation() {
        OngoingStubbingImpl ongoingStubbing = (OngoingStubbingImpl)this.mockingProgress.pullOngoingStubbing();
        List<Invocation> allInvocations = ongoingStubbing.getRegisteredInvocations();
        return allInvocations.get(allInvocations.size() - 1);
    }
}

