/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Processor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorSelector;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.Futures;

public class UDPNIOServerConnection
extends UDPNIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOServerConnection.class);

    public UDPNIOServerConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport, channel);
    }

    @Override
    public Processor getProcessor() {
        if (this.processor == null) {
            return this.transport.getProcessor();
        }
        return this.processor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        if (this.processorSelector == null) {
            return this.transport.getProcessorSelector();
        }
        return this.processorSelector;
    }

    public void register() throws IOException {
        FutureImpl future = Futures.createSafeFuture();
        this.transport.getNIOChannelDistributor().registerChannelAsync(this.channel, 1, this, Futures.toCompletionHandler(future, ((UDPNIOTransport)this.transport).registerChannelCompletionHandler));
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException("Error registering server channel key", e);
        }
        this.notifyReady();
    }

    @Override
    public void close(CompletionHandler<Connection> completionHandler) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("UDPNIOServerConnection might be only closed by calling unbind().");
        }
        if (completionHandler != null) {
            completionHandler.completed(this);
        }
    }

    public void unbind(CompletionHandler<Connection> completionHandler) {
        super.close(completionHandler);
    }

    @Override
    protected void preClose() {
        try {
            ((UDPNIOTransport)this.transport).unbind(this);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception occurred, when unbind connection: " + this, e);
        }
        super.preClose();
    }
}

