/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.CombinedHostFileManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AdminStatesBaseTest {
    public static final Log LOG = LogFactory.getLog(AdminStatesBaseTest.class);
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int HEARTBEAT_INTERVAL = 1;
    static final int BLOCKREPORT_INTERVAL_MSEC = 1000;
    static final int NAMENODE_REPLICATION_INTERVAL = 1;
    private final Random myrand = new Random();
    private HostsFileWriter hostsFileWriter;
    private Configuration conf;
    private MiniDFSCluster cluster = null;
    private boolean useCombinedHostFileManager = false;

    protected void setUseCombinedHostFileManager() {
        this.useCombinedHostFileManager = true;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected MiniDFSCluster getCluster() {
        return this.cluster;
    }

    @Before
    public void setup() throws IOException {
        this.hostsFileWriter = new HostsFileWriter();
        this.conf = new HdfsConfiguration();
        if (this.useCombinedHostFileManager) {
            this.conf.setClass("dfs.namenode.hosts.provider.classname", CombinedHostFileManager.class, HostConfigManager.class);
        }
        this.conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 200);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.blockreport.intervalMsec", 1000);
        this.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        this.conf.setInt("dfs.namenode.decommission.interval", 1);
        this.hostsFileWriter.initialize(this.conf, "temp/admin");
    }

    @After
    public void teardown() throws IOException {
        this.hostsFileWriter.cleanup();
        this.shutdownCluster();
    }

    public static FSDataOutputStream writeIncompleteFile(FileSystem fileSys, Path name, short repl, short numOfBlocks) throws IOException {
        return AdminStatesBaseTest.writeFile(fileSys, name, repl, numOfBlocks, false);
    }

    protected static void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        AdminStatesBaseTest.writeFile(fileSys, name, repl, 2);
    }

    protected static void writeFile(FileSystem fileSys, Path name, int repl, int numOfBlocks) throws IOException {
        AdminStatesBaseTest.writeFile(fileSys, name, repl, numOfBlocks, true);
    }

    protected static FSDataOutputStream writeFile(FileSystem fileSys, Path name, int repl, int numOfBlocks, boolean completeFile) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[8192 * numOfBlocks];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        LOG.info((Object)("Created file " + name + " with " + repl + " replicas."));
        if (completeFile) {
            stm.close();
            return null;
        }
        stm.flush();
        return stm;
    }

    protected DatanodeInfo takeNodeOutofService(int nnIndex, String datanodeUuid, long maintenanceExpirationInMS, ArrayList<DatanodeInfo> decommissionedNodes, DatanodeInfo.AdminStates waitForState) throws IOException {
        return this.takeNodeOutofService(nnIndex, datanodeUuid, maintenanceExpirationInMS, decommissionedNodes, null, waitForState);
    }

    protected DatanodeInfo takeNodeOutofService(int nnIndex, String datanodeUuid, long maintenanceExpirationInMS, List<DatanodeInfo> decommissionedNodes, Map<DatanodeInfo, Long> inMaintenanceNodes, DatanodeInfo.AdminStates waitForState) throws IOException {
        return this.takeNodeOutofService(nnIndex, datanodeUuid != null ? Lists.newArrayList((Object[])new String[]{datanodeUuid}) : null, maintenanceExpirationInMS, decommissionedNodes, inMaintenanceNodes, waitForState).get(0);
    }

    protected List<DatanodeInfo> takeNodeOutofService(int nnIndex, List<String> dataNodeUuids, long maintenanceExpirationInMS, List<DatanodeInfo> decommissionedNodes, Map<DatanodeInfo, Long> inMaintenanceNodes, DatanodeInfo.AdminStates waitForState) throws IOException {
        DFSClient client = this.getDfsClient(nnIndex);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
        boolean isDecommissionRequest = waitForState == DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS || waitForState == DatanodeInfo.AdminStates.DECOMMISSIONED;
        ArrayList<String> dataNodeNames = new ArrayList<String>();
        ArrayList<DatanodeInfo> datanodeInfos = new ArrayList<DatanodeInfo>();
        if (dataNodeUuids == null) {
            boolean found = false;
            while (!found) {
                int index = this.myrand.nextInt(info.length);
                if ((!isDecommissionRequest || info[index].isDecommissioned()) && (isDecommissionRequest || info[index].isInMaintenance())) continue;
                dataNodeNames.add(info[index].getXferAddr());
                datanodeInfos.add(NameNodeAdapter.getDatanode(this.cluster.getNamesystem(nnIndex), (DatanodeID)info[index]));
                found = true;
            }
        } else {
            for (String datanodeUuid : dataNodeUuids) {
                boolean found = false;
                for (int index = 0; index < info.length; ++index) {
                    if (!info[index].getDatanodeUuid().equals(datanodeUuid)) continue;
                    dataNodeNames.add(info[index].getXferAddr());
                    datanodeInfos.add(NameNodeAdapter.getDatanode(this.cluster.getNamesystem(nnIndex), (DatanodeID)info[index]));
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IOException("invalid datanodeUuid " + datanodeUuid);
            }
        }
        LOG.info((Object)("Taking node: " + Arrays.toString(dataNodeNames.toArray()) + " out of service"));
        ArrayList<String> decommissionNodes = new ArrayList<String>();
        if (decommissionedNodes != null) {
            for (DatanodeInfo dn : decommissionedNodes) {
                decommissionNodes.add(dn.getName());
            }
        }
        HashMap<String, Long> maintenanceNodes = new HashMap<String, Long>();
        if (inMaintenanceNodes != null) {
            for (Map.Entry<DatanodeInfo, Long> dn : inMaintenanceNodes.entrySet()) {
                maintenanceNodes.put(dn.getKey().getName(), dn.getValue());
            }
        }
        if (isDecommissionRequest) {
            for (String dataNodeName : dataNodeNames) {
                decommissionNodes.add(dataNodeName);
            }
        } else {
            for (String dataNodeName : dataNodeNames) {
                maintenanceNodes.put(dataNodeName, maintenanceExpirationInMS);
            }
        }
        this.hostsFileWriter.initOutOfServiceHosts(decommissionNodes, maintenanceNodes);
        this.refreshNodes(nnIndex);
        this.waitNodeState(datanodeInfos, waitForState);
        return datanodeInfos;
    }

    protected void putNodeInService(int nnIndex, DatanodeInfo outOfServiceNode) throws IOException {
        LOG.info((Object)("Putting node: " + outOfServiceNode + " in service"));
        ArrayList<String> decommissionNodes = new ArrayList<String>();
        HashMap<String, Long> maintenanceNodes = new HashMap<String, Long>();
        DatanodeManager dm = this.cluster.getNamesystem(nnIndex).getBlockManager().getDatanodeManager();
        List<DatanodeDescriptor> nodes = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
        for (DatanodeDescriptor node : nodes) {
            if (node.isMaintenance()) {
                maintenanceNodes.put(node.getName(), node.getMaintenanceExpireTimeInMS());
                continue;
            }
            if (!node.isDecommissionInProgress() && !node.isDecommissioned()) continue;
            decommissionNodes.add(node.getName());
        }
        decommissionNodes.remove(outOfServiceNode.getName());
        maintenanceNodes.remove(outOfServiceNode.getName());
        this.hostsFileWriter.initOutOfServiceHosts(decommissionNodes, maintenanceNodes);
        this.refreshNodes(nnIndex);
        this.waitNodeState(outOfServiceNode, DatanodeInfo.AdminStates.NORMAL);
    }

    protected void putNodeInService(int nnIndex, String datanodeUuid) throws IOException {
        DatanodeDescriptor datanodeInfo = AdminStatesBaseTest.getDatanodeDesriptor(this.cluster.getNamesystem(nnIndex), datanodeUuid);
        this.putNodeInService(nnIndex, datanodeInfo);
    }

    protected void waitNodeState(DatanodeInfo node, DatanodeInfo.AdminStates state) {
        this.waitNodeState(Lists.newArrayList((Object[])new DatanodeInfo[]{node}), state);
    }

    protected void waitNodeState(List<DatanodeInfo> nodes, DatanodeInfo.AdminStates state) {
        for (DatanodeInfo node : nodes) {
            boolean done;
            boolean bl = done = state == node.getAdminState();
            while (!done) {
                LOG.info((Object)("Waiting for node " + node + " to change state to " + state + " current state: " + node.getAdminState()));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                done = state == node.getAdminState();
            }
            LOG.info((Object)("node " + node + " reached the state " + state));
        }
    }

    protected void initIncludeHost(String hostNameAndPort) throws IOException {
        this.hostsFileWriter.initIncludeHost(hostNameAndPort);
    }

    protected void initIncludeHosts(String[] hostNameAndPorts) throws IOException {
        this.hostsFileWriter.initIncludeHosts(hostNameAndPorts);
    }

    protected void initExcludeHost(String hostNameAndPort) throws IOException {
        this.hostsFileWriter.initExcludeHost(hostNameAndPort);
    }

    protected void initExcludeHosts(List<String> hostNameAndPorts) throws IOException {
        this.hostsFileWriter.initExcludeHosts(hostNameAndPorts);
    }

    protected DFSClient getDfsClient(int nnIndex) throws IOException {
        return new DFSClient(this.cluster.getNameNode(nnIndex).getNameNodeAddress(), this.conf);
    }

    protected static void validateCluster(DFSClient client, int numDNs) throws IOException {
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        Assert.assertEquals((String)"Number of Datanodes ", (long)numDNs, (long)info.length);
    }

    protected void startCluster(int numNameNodes, int numDatanodes, boolean setupHostsFile, long[] nodesCapacity, boolean checkDataNodeHostConfig) throws IOException {
        this.startCluster(numNameNodes, numDatanodes, setupHostsFile, nodesCapacity, checkDataNodeHostConfig, true);
    }

    protected void startCluster(int numNameNodes, int numDatanodes, boolean setupHostsFile, long[] nodesCapacity, boolean checkDataNodeHostConfig, boolean federation) throws IOException {
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDatanodes);
        if (federation) {
            builder.nnTopology(MiniDFSNNTopology.simpleFederatedTopology(numNameNodes));
        }
        if (setupHostsFile) {
            builder.setupHostsFile(setupHostsFile);
        }
        if (nodesCapacity != null) {
            builder.simulatedCapacities(nodesCapacity);
        }
        if (checkDataNodeHostConfig) {
            builder.checkDataNodeHostConfig(checkDataNodeHostConfig);
        }
        this.cluster = builder.build();
        this.cluster.waitActive();
        for (int i = 0; i < numNameNodes; ++i) {
            DFSClient client = this.getDfsClient(i);
            AdminStatesBaseTest.validateCluster(client, numDatanodes);
        }
    }

    protected void startCluster(int numNameNodes, int numDatanodes) throws IOException {
        this.startCluster(numNameNodes, numDatanodes, false, null, false);
    }

    protected void startSimpleCluster(int numNameNodes, int numDatanodes) throws IOException {
        this.startCluster(numNameNodes, numDatanodes, false, null, false, false);
    }

    protected void startSimpleHACluster(int numDatanodes) throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(numDatanodes).build();
        this.cluster.transitionToActive(0);
        this.cluster.waitActive();
    }

    protected void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown(true);
        }
    }

    protected void refreshNodes(int nnIndex) throws IOException {
        this.cluster.getNamesystem(nnIndex).getBlockManager().getDatanodeManager().refreshNodes(this.conf);
    }

    private static DatanodeDescriptor getDatanodeDesriptor(FSNamesystem ns, String datanodeUuid) {
        return ns.getBlockManager().getDatanodeManager().getDatanode(datanodeUuid);
    }

    public static void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }
}

