/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import redis.embedded.util.Architecture;
import redis.embedded.util.JarUtil;
import redis.embedded.util.OS;
import redis.embedded.util.OsArchitecture;

public class RedisExecProvider {
    private final Map<OsArchitecture, String> executables = Maps.newHashMap();

    public static RedisExecProvider defaultProvider() {
        return new RedisExecProvider();
    }

    private RedisExecProvider() {
        this.initExecutables();
    }

    private void initExecutables() {
        this.executables.put(OsArchitecture.WINDOWS_x86, "redis-server-2.8.19.exe");
        this.executables.put(OsArchitecture.WINDOWS_x86_64, "redis-server-2.8.19.exe");
        this.executables.put(OsArchitecture.UNIX_x86, "redis-server-2.8.19-32");
        this.executables.put(OsArchitecture.UNIX_x86_64, "redis-server-2.8.19");
        this.executables.put(OsArchitecture.UNIX_aarch64, "redis-server-2.8.19-aarch64");
        this.executables.put(OsArchitecture.MAC_OS_X_x86, "redis-server-2.8.19.app");
        this.executables.put(OsArchitecture.MAC_OS_X_x86_64, "redis-server-2.8.19.app");
    }

    public RedisExecProvider override(OS os, String executable) {
        Preconditions.checkNotNull((Object)executable);
        for (Architecture arch : Architecture.values()) {
            this.override(os, arch, executable);
        }
        return this;
    }

    public RedisExecProvider override(OS os, Architecture arch, String executable) {
        Preconditions.checkNotNull((Object)executable);
        this.executables.put(new OsArchitecture(os, arch), executable);
        return this;
    }

    public File get() throws IOException {
        OsArchitecture osArch = OsArchitecture.detect();
        String executablePath = this.executables.get(osArch);
        return this.fileExists(executablePath) ? new File(executablePath) : JarUtil.extractExecutableFromJar(executablePath);
    }

    private boolean fileExists(String executablePath) {
        return new File(executablePath).exists();
    }
}

