/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.tests.UnixTestUtils;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;

class KQueueSocketTestPermutation
extends SocketTestPermutation {
    static final KQueueSocketTestPermutation INSTANCE = new KQueueSocketTestPermutation();
    static final EventLoopGroup KQUEUE_BOSS_GROUP = new KQueueEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-KQueue-boss", true));
    static final EventLoopGroup KQUEUE_WORKER_GROUP = new KQueueEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("testsuite-KQueue-worker", true));
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueSocketTestPermutation.class);

    KQueueSocketTestPermutation() {
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List list = this.combo(this.serverSocket(), this.clientSocket());
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> toReturn = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQUEUE_BOSS_GROUP, KQUEUE_WORKER_GROUP).channel(KQueueServerSocketChannel.class);
            }
        });
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQueueSocketTestPermutation.this.nioBossGroup, KQueueSocketTestPermutation.this.nioWorkerGroup).channel(NioServerSocketChannel.class);
            }
        });
        return toReturn;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueSocketChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQueueSocketTestPermutation.this.nioWorkerGroup)).channel(NioSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram(final InternetProtocolFamily family) {
        List<TestsuitePermutation.BootstrapFactory> bfs = Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQueueSocketTestPermutation.this.nioWorkerGroup)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(family);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDatagramChannel.class);
            }
        });
        return this.combo(bfs, bfs);
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> domainSocket() {
        List list = this.combo(this.serverDomainSocket(), this.clientDomainSocket());
        return list;
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQUEUE_BOSS_GROUP, KQUEUE_WORKER_GROUP).channel(KQueueServerDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> datagramSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDatagramChannel.class);
            }
        });
    }

    public static DomainSocketAddress newSocketAddress() {
        return UnixTestUtils.newSocketAddress();
    }
}

