/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketAutoReadTest
extends AbstractSocketTest {
    private static final Random random = new Random();
    static final byte[] data = new byte[1024];

    @Test(timeout=30000L)
    public void testAutoReadDisableOutsideChannelRead() throws Throwable {
        this.run();
    }

    public void testAutoReadDisableOutsideChannelRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        TestHandler sh = new TestHandler(){
            private boolean allBytesReceived;

            @Override
            public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
                Assert.assertFalse((boolean)this.allBytesReceived);
                ctx.writeAndFlush(msg);
                ctx.channel().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        ctx.channel().config().setAutoRead(false);
                        allBytesReceived = true;
                    }
                });
            }
        };
        sb.childHandler((ChannelHandler)sh);
        TestHandler ch = new TestHandler();
        cb.handler((ChannelHandler)ch);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data)).sync();
        Thread.sleep(500L);
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data)).sync();
        Thread.sleep(500L);
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data)).sync();
        Thread.sleep(500L);
        cc.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    @Test(timeout=30000L)
    public void testAutoReadDisableOutsideChannelReadManualRead() throws Throwable {
        this.run();
    }

    public void testAutoReadDisableOutsideChannelReadManualRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        ServerTestHandler sh = new ServerTestHandler();
        sb.childHandler((ChannelHandler)sh);
        TestHandler ch = new TestHandler();
        cb.handler((ChannelHandler)ch);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data)).sync();
        Thread.sleep(500L);
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data)).sync();
        Thread.sleep(500L);
        cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data)).sync();
        Thread.sleep(500L);
        sh.await();
        cc.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw (Throwable)sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw (Throwable)sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        random.nextBytes(data);
    }

    private static class TestHandler
    extends ChannelInboundHandlerAdapter {
        final AtomicReference<Throwable> exception = new AtomicReference();

        private TestHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                cause.printStackTrace();
                ctx.close();
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public static class ServerTestHandler
    extends TestHandler {
        private final CountDownLatch latch = new CountDownLatch(1);
        private State state = State.AUTO_READ;

        @Override
        public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.writeAndFlush(msg);
            switch (this.state) {
                case READ_SCHEDULED: {
                    this.latch.countDown();
                    break;
                }
                case AUTO_READ: {
                    this.state = State.SCHEDULED;
                    ctx.channel().eventLoop().execute(new Runnable(){

                        @Override
                        public void run() {
                            ctx.channel().config().setAutoRead(false);
                            ServerTestHandler.this.state = State.BYTES_RECEIVED;
                            ctx.channel().eventLoop().schedule(new Runnable(){

                                @Override
                                public void run() {
                                    ServerTestHandler.this.state = State.READ_SCHEDULED;
                                    ctx.channel().read();
                                }
                            }, 2L, TimeUnit.SECONDS);
                        }
                    });
                    break;
                }
                case BYTES_RECEIVED: {
                    Assert.fail();
                    break;
                }
            }
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }

        static enum State {
            AUTO_READ,
            SCHEDULED,
            BYTES_RECEIVED,
            READ_SCHEDULED;

        }
    }
}

