/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.Slf4JLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class Slf4JLoggerTest {
    private static final Exception e = new Exception();

    @Test
    public void testIsTraceEnabled() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)mockLogger.isTraceEnabled()).thenReturn((Object)true);
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        Assert.assertTrue((boolean)logger.isTraceEnabled());
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).isTraceEnabled();
    }

    @Test
    public void testIsDebugEnabled() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)mockLogger.isDebugEnabled()).thenReturn((Object)true);
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        Assert.assertTrue((boolean)logger.isDebugEnabled());
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).isDebugEnabled();
    }

    @Test
    public void testIsInfoEnabled() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)mockLogger.isInfoEnabled()).thenReturn((Object)true);
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        Assert.assertTrue((boolean)logger.isInfoEnabled());
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).isInfoEnabled();
    }

    @Test
    public void testIsWarnEnabled() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)mockLogger.isWarnEnabled()).thenReturn((Object)true);
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        Assert.assertTrue((boolean)logger.isWarnEnabled());
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).isWarnEnabled();
    }

    @Test
    public void testIsErrorEnabled() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)mockLogger.isErrorEnabled()).thenReturn((Object)true);
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        Assert.assertTrue((boolean)logger.isErrorEnabled());
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).isErrorEnabled();
    }

    @Test
    public void testTrace() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.trace("a");
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).trace("a");
    }

    @Test
    public void testTraceWithException() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.trace("a", (Throwable)e);
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).trace("a", (Throwable)e);
    }

    @Test
    public void testDebug() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.debug("a");
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).debug("a");
    }

    @Test
    public void testDebugWithException() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.debug("a", (Throwable)e);
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).debug("a", (Throwable)e);
    }

    @Test
    public void testInfo() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.info("a");
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).info("a");
    }

    @Test
    public void testInfoWithException() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.info("a", (Throwable)e);
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).info("a", (Throwable)e);
    }

    @Test
    public void testWarn() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.warn("a");
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).warn("a");
    }

    @Test
    public void testWarnWithException() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.warn("a", (Throwable)e);
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).warn("a", (Throwable)e);
    }

    @Test
    public void testError() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.error("a");
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).error("a");
    }

    @Test
    public void testErrorWithException() {
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogger.getName()).thenReturn((Object)"foo");
        Slf4JLogger logger = new Slf4JLogger(mockLogger);
        logger.error("a", (Throwable)e);
        ((Logger)Mockito.verify((Object)mockLogger)).getName();
        ((Logger)Mockito.verify((Object)mockLogger)).error("a", (Throwable)e);
    }
}

