/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.NonStickyEventExecutorGroup;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.UnorderedThreadPoolEventExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NonStickyEventExecutorGroupTest {
    private final int maxTaskExecutePerRun;

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidGroup() {
        DefaultEventExecutorGroup group = new DefaultEventExecutorGroup(1);
        try {
            new NonStickyEventExecutorGroup((EventExecutorGroup)group);
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Parameterized.Parameters(name="{index}: maxTaskExecutePerRun = {0}")
    public static Collection<Object[]> data() throws Exception {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{64});
        params.add(new Object[]{256});
        params.add(new Object[]{1024});
        params.add(new Object[]{Integer.MAX_VALUE});
        return params;
    }

    public NonStickyEventExecutorGroupTest(int maxTaskExecutePerRun) {
        this.maxTaskExecutePerRun = maxTaskExecutePerRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testOrdering() throws Throwable {
        int threads = NettyRuntime.availableProcessors() * 2;
        UnorderedThreadPoolEventExecutor group = new UnorderedThreadPoolEventExecutor(threads);
        final NonStickyEventExecutorGroup nonStickyGroup = new NonStickyEventExecutorGroup((EventExecutorGroup)group, this.maxTaskExecutePerRun);
        try {
            final CountDownLatch startLatch = new CountDownLatch(1);
            final AtomicReference error = new AtomicReference();
            ArrayList<Thread> threadList = new ArrayList<Thread>(threads);
            for (int i = 0; i < threads; ++i) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            NonStickyEventExecutorGroupTest.execute((EventExecutorGroup)nonStickyGroup, startLatch);
                        }
                        catch (Throwable cause) {
                            error.compareAndSet(null, cause);
                        }
                    }
                });
                threadList.add(thread);
                thread.start();
            }
            startLatch.countDown();
            for (Thread t : threadList) {
                t.join();
            }
            Throwable cause = (Throwable)error.get();
            if (cause != null) {
                throw cause;
            }
        }
        finally {
            nonStickyGroup.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceCondition() throws InterruptedException {
        UnorderedThreadPoolEventExecutor group = new UnorderedThreadPoolEventExecutor(1);
        NonStickyEventExecutorGroup nonStickyGroup = new NonStickyEventExecutorGroup((EventExecutorGroup)group, this.maxTaskExecutePerRun);
        try {
            EventExecutor executor = nonStickyGroup.next();
            for (int j = 0; j < 5000; ++j) {
                final CountDownLatch firstCompleted = new CountDownLatch(1);
                final CountDownLatch latch = new CountDownLatch(2);
                for (int i = 0; i < 2; ++i) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            firstCompleted.countDown();
                            latch.countDown();
                        }
                    });
                    Assert.assertTrue((boolean)firstCompleted.await(1L, TimeUnit.SECONDS));
                }
                Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            }
        }
        finally {
            nonStickyGroup.shutdownGracefully();
        }
    }

    private static void execute(EventExecutorGroup group, CountDownLatch startLatch) throws Throwable {
        EventExecutor executor = group.next();
        Assert.assertTrue((boolean)(executor instanceof OrderedEventExecutor));
        final AtomicReference cause = new AtomicReference();
        final AtomicInteger last = new AtomicInteger();
        int tasks = 10000;
        ArrayList<Future> futures = new ArrayList<Future>(tasks);
        final CountDownLatch latch = new CountDownLatch(tasks);
        startLatch.await();
        int i = 1;
        while (i <= tasks) {
            final int id = i++;
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (cause.get() == null) {
                            int lastId = last.get();
                            if (lastId >= id) {
                                cause.compareAndSet(null, new AssertionError((Object)("Out of order execution id(" + id + ") >= lastId(" + lastId + ')')));
                            }
                            if (!last.compareAndSet(lastId, id)) {
                                cause.compareAndSet(null, new AssertionError((Object)"Concurrent execution of tasks"));
                            }
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }));
        }
        latch.await();
        for (Future future : futures) {
            future.syncUninterruptibly();
        }
        Throwable error = (Throwable)cause.get();
        if (error != null) {
            throw error;
        }
    }
}

