/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.ShortObjectHashMap;
import io.netty.util.collection.ShortObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShortObjectHashMapTest {
    private ShortObjectHashMap<Value> map;

    @Before
    public void setup() {
        this.map = new ShortObjectHashMap();
    }

    @Test
    public void iteartorRemoveShouldNotNPE() {
        this.map = new ShortObjectHashMap(4, 1.0f);
        this.map.put(Short.valueOf((short)0), (Object)new Value("A"));
        this.map.put(Short.valueOf((short)1), (Object)new Value("B"));
        this.map.put(Short.valueOf((short)4), (Object)new Value("C"));
        this.map.remove((Object)1);
        Iterator itr = this.map.entries().iterator();
        while (itr.hasNext()) {
            ShortObjectMap.PrimitiveEntry entry = (ShortObjectMap.PrimitiveEntry)itr.next();
            Assert.assertNotNull((Object)entry.key());
            Assert.assertNotNull((Object)entry.value());
            itr.remove();
        }
        Assert.assertTrue((boolean)this.map.isEmpty());
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void putNewMappingShouldSucceed() {
        Value v = new Value("v");
        short key = 1;
        Assert.assertNull((Object)this.map.put(key, (Object)v));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey(key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
        Assert.assertEquals((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void putNewMappingShouldSucceed_mapApi() {
        Value v = new Value("v");
        Short key = 1;
        Assert.assertNull((Object)this.map.put(key, (Object)v));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey((Object)key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
        Assert.assertEquals((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldReplaceValue() {
        Value v1 = new Value("v1");
        short key = 1;
        Assert.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assert.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey(key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assert.assertEquals((Object)v2, (Object)this.map.get(key));
    }

    @Test
    public void putShouldReplaceValue_mapApi() {
        Value v1 = new Value("v1");
        Short key = 1;
        Assert.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assert.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey((Object)key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assert.assertEquals((Object)v2, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldGrowMap() {
        for (short key = 0; key < 255; key = (short)(key + 1)) {
            Value v = new Value(Short.toString(key));
            Assert.assertNull((Object)this.map.put(key, (Object)v));
            Assert.assertEquals((long)(key + 1), (long)this.map.size());
            Assert.assertTrue((boolean)this.map.containsKey(key));
            Assert.assertTrue((boolean)this.map.containsValue((Object)v));
            Assert.assertEquals((Object)v, (Object)this.map.get(key));
        }
    }

    @Test
    public void putShouldGrowMap_mapApi() {
        for (short key = 0; key < 255; key = (short)(key + 1)) {
            Short okey = key;
            Value v = new Value(Short.toString(key));
            Assert.assertNull((Object)this.map.put(okey, (Object)v));
            Assert.assertEquals((long)(key + 1), (long)this.map.size());
            Assert.assertTrue((boolean)this.map.containsKey((Object)okey));
            Assert.assertTrue((boolean)this.map.containsValue((Object)v));
            Assert.assertEquals((Object)v, (Object)this.map.get((Object)okey));
        }
    }

    @Test
    public void negativeKeyShouldSucceed() {
        Value v = new Value("v");
        this.map.put((short)-3, (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertEquals((Object)v, (Object)this.map.get((short)-3));
    }

    @Test
    public void negativeKeyShouldSucceed_mapApi() {
        Value v = new Value("v");
        this.map.put(Short.valueOf((short)-3), (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertEquals((Object)v, (Object)this.map.get((Object)-3));
    }

    @Test
    public void removeMissingValueShouldReturnNull() {
        Assert.assertNull((Object)this.map.remove((short)1));
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void removeMissingValueShouldReturnNull_mapApi() {
        Assert.assertNull((Object)this.map.remove((Object)1));
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void removeShouldReturnPreviousValue() {
        Value v = new Value("v");
        short key = 1;
        this.map.put(key, (Object)v);
        Assert.assertSame((Object)v, (Object)this.map.remove(key));
    }

    @Test
    public void removeShouldReturnPreviousValue_mapApi() {
        Value v = new Value("v");
        Short key = 1;
        this.map.put(key, (Object)v);
        Assert.assertSame((Object)v, (Object)this.map.remove((Object)key));
    }

    @Test
    public void noFreeSlotsShouldRehash() {
        for (short i = 0; i < 10; i = (short)(i + 1)) {
            this.map.put(i, (Object)new Value(Short.toString(i)));
            this.map.remove(i);
            Assert.assertEquals((long)0L, (long)this.map.size());
        }
        Value v = new Value("v");
        short key = 1;
        this.map.put(key, (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertSame((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void noFreeSlotsShouldRehash_mapApi() {
        for (short i = 0; i < 10; i = (short)(i + 1)) {
            this.map.put(i, (Object)new Value(Short.toString(i)));
            this.map.remove((Object)i);
            Assert.assertEquals((long)0L, (long)this.map.size());
        }
        Value v = new Value("v");
        Short key = 1;
        this.map.put(key, (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertSame((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putAllShouldSucceed() {
        ShortObjectHashMap other = new ShortObjectHashMap();
        short k1 = 1;
        short k2 = 2;
        short k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assert.assertEquals((long)3L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get(k1));
        Assert.assertSame((Object)v2, (Object)this.map.get(k2));
        Assert.assertSame((Object)v3, (Object)this.map.get(k3));
    }

    @Test
    public void putAllShouldSucceed_mapApi() {
        ShortObjectHashMap other = new ShortObjectHashMap();
        Short k1 = 1;
        Short k2 = 2;
        Short k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assert.assertEquals((long)3L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assert.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assert.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void putAllWithJavaMapShouldSucceed_mapApi() {
        HashMap<Short, Value> other = new HashMap<Short, Value>();
        Short k1 = 1;
        Short k2 = 2;
        Short k3 = 3;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, v1);
        other.put(k2, v2);
        other.put(k3, v3);
        this.map.putAll(other);
        Assert.assertEquals((long)3L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assert.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assert.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void clearShouldSucceed() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put((short)1, (Object)v1);
        this.map.put((short)2, (Object)v2);
        this.map.put((short)3, (Object)v3);
        this.map.clear();
        Assert.assertEquals((long)0L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValueShouldFindNull() {
        this.map.put((short)1, (Object)new Value("v1"));
        this.map.put((short)2, null);
        this.map.put((short)3, (Object)new Value("v2"));
        Assert.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindNull_mapApi() {
        this.map.put(Short.valueOf((short)1), (Object)new Value("v1"));
        this.map.put(Short.valueOf((short)2), null);
        this.map.put(Short.valueOf((short)3), (Object)new Value("v2"));
        Assert.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindInstance() {
        Value v = new Value("v1");
        this.map.put((short)1, (Object)new Value("v2"));
        this.map.put((short)2, (Object)new Value("v3"));
        this.map.put((short)3, (Object)v);
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindInstance_mapApi() {
        Value v = new Value("v1");
        this.map.put(Short.valueOf((short)1), (Object)new Value("v2"));
        this.map.put(Short.valueOf((short)2), (Object)new Value("v3"));
        this.map.put(Short.valueOf((short)3), (Object)v);
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindEquivalentValue() {
        this.map.put((short)1, (Object)new Value("v1"));
        this.map.put((short)2, (Object)new Value("v2"));
        this.map.put((short)3, (Object)new Value("v3"));
        Assert.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueShouldFindEquivalentValue_mapApi() {
        this.map.put(Short.valueOf((short)1), (Object)new Value("v1"));
        this.map.put(Short.valueOf((short)2), (Object)new Value("v2"));
        this.map.put(Short.valueOf((short)3), (Object)new Value("v3"));
        Assert.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueNotFindMissingValue() {
        this.map.put((short)1, (Object)new Value("v1"));
        this.map.put((short)2, (Object)new Value("v2"));
        this.map.put((short)3, (Object)new Value("v3"));
        Assert.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void containsValueNotFindMissingValue_mapApi() {
        this.map.put(Short.valueOf((short)1), (Object)new Value("v1"));
        this.map.put(Short.valueOf((short)2), (Object)new Value("v2"));
        this.map.put(Short.valueOf((short)3), (Object)new Value("v3"));
        Assert.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void iteratorShouldTraverseEntries() {
        short k1 = 1;
        short k2 = 2;
        short k3 = 3;
        short k4 = 4;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet found = new HashSet();
        for (Map.Entry entry : this.map.entrySet()) {
            Assert.assertTrue((boolean)found.add(entry.getKey()));
        }
        Assert.assertEquals((long)3L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(k1));
        Assert.assertTrue((boolean)found.contains(k2));
        Assert.assertTrue((boolean)found.contains(k3));
    }

    @Test
    public void keysShouldBeReturned() {
        short k1 = 1;
        short k2 = 2;
        short k3 = 3;
        short k4 = 4;
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        Set keys = this.map.keySet();
        Assert.assertEquals((long)3L, (long)keys.size());
        HashSet<Short> expected = new HashSet<Short>();
        expected.add(k1);
        expected.add(k2);
        expected.add(k3);
        HashSet<Short> found = new HashSet<Short>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            short key = (Short)iterator.next();
            Assert.assertTrue((boolean)found.add(key));
        }
        Assert.assertEquals(expected, found);
    }

    @Test
    public void valuesShouldBeReturned() {
        short k1 = 1;
        short k2 = 2;
        short k3 = 3;
        short k4 = 4;
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(k1, (Object)v1);
        this.map.put(k2, (Object)v2);
        this.map.put(k3, (Object)v3);
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Value> expected = new HashSet<Value>();
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        HashSet actual = new HashSet(this.map.values());
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void mapShouldSupportHashingConflicts() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                ShortObjectHashMap map = new ShortObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put((short)(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void mapShouldSupportHashingConflicts_mapApi() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                ShortObjectHashMap map = new ShortObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(Short.valueOf((short)(i * mod)), (Object)"");
                }
            }
        }
    }

    @Test
    public void hashcodeEqualsTest() {
        ShortObjectHashMap map1 = new ShortObjectHashMap();
        ShortObjectHashMap map2 = new ShortObjectHashMap();
        Random rnd = new Random(0L);
        while (map1.size() < 100) {
            short key = (short)rnd.nextInt(100);
            map1.put(key, (Object)key);
            map2.put(key, (Object)key);
        }
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        Assert.assertEquals((Object)map1, (Object)map2);
        Set keys = map1.keySet();
        Short removed = null;
        Iterator iter = keys.iterator();
        for (int ix = 0; iter.hasNext() && ix < 50; ++ix) {
            removed = (Short)iter.next();
        }
        map2.remove(removed);
        Assert.assertFalse((boolean)map1.equals((Object)map2));
        map2.put(removed, (Object)removed);
        Assert.assertEquals((Object)map1, (Object)map2);
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        map2.put((short)100, (Object)100);
        Assert.assertFalse((boolean)map1.equals((Object)map2));
        map2.clear();
        for (Short key : map1.keySet()) {
            map2.put(key, (Object)key);
        }
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        Assert.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void fuzzTest() {
        short key;
        int i;
        Random rnd = new Random(0L);
        int baseSize = 1000;
        int startTableSize = 1105;
        ShortObjectHashMap map = new ShortObjectHashMap(startTableSize);
        HashMap<Short, Short> goodMap = new HashMap<Short, Short>();
        for (i = 0; i < baseSize / 4; ++i) {
            key = (short)rnd.nextInt(baseSize);
            Assert.assertEquals((Object)goodMap.put(key, key), (Object)map.put(key, (Object)key));
            key = (short)(rnd.nextInt(baseSize) * 17);
            Assert.assertEquals((Object)goodMap.put(key, key), (Object)map.put(key, (Object)key));
        }
        for (i = 0; i < baseSize * 1000; ++i) {
            key = (short)rnd.nextInt(baseSize);
            if (rnd.nextDouble() >= 0.2) {
                Assert.assertEquals((Object)goodMap.put(key, key), (Object)map.put(key, (Object)key));
                continue;
            }
            Assert.assertEquals(goodMap.remove(key), (Object)map.remove(key));
        }
        int removeSize = map.size() / 2;
        while (removeSize > 0) {
            key = (short)rnd.nextInt(baseSize);
            boolean found = goodMap.containsKey(key);
            Assert.assertEquals((Object)found, (Object)map.containsKey(key));
            Assert.assertEquals(goodMap.remove(key), (Object)map.remove(key));
            if (!found) continue;
            --removeSize;
        }
        Assert.assertEquals((long)goodMap.size(), (long)map.size());
        Object[] goodKeys = goodMap.keySet().toArray(new Short[goodMap.size()]);
        Arrays.sort(goodKeys);
        Object[] keys = map.keySet().toArray(new Short[map.size()]);
        Arrays.sort(keys);
        for (int i2 = 0; i2 < goodKeys.length; ++i2) {
            Assert.assertEquals((Object)goodKeys[i2], (Object)keys[i2]);
        }
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            short key2 = (Short)objectArray[j];
            Assert.assertEquals(goodMap.remove(key2), (Object)map.remove(key2));
        }
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void valuesIteratorRemove() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put((short)1, (Object)v1);
        this.map.put((short)2, (Object)v2);
        this.map.put((short)3, (Object)v3);
        Iterator it = this.map.values().iterator();
        Assert.assertSame((Object)v1, it.next());
        Assert.assertSame((Object)v2, it.next());
        it.remove();
        Assert.assertSame((Object)v3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)2L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get((short)1));
        Assert.assertNull((Object)this.map.get((short)2));
        Assert.assertSame((Object)v3, (Object)this.map.get((short)3));
        it = this.map.values().iterator();
        Assert.assertSame((Object)v1, it.next());
        Assert.assertSame((Object)v3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    private static class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

