/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.collection.CharObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CharObjectHashMapTest {
    private CharObjectHashMap<Value> map;

    @Before
    public void setup() {
        this.map = new CharObjectHashMap();
    }

    @Test
    public void iteartorRemoveShouldNotNPE() {
        this.map = new CharObjectHashMap(4, 1.0f);
        this.map.put(Character.valueOf('\u0000'), (Object)new Value("A"));
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("B"));
        this.map.put(Character.valueOf('\u0004'), (Object)new Value("C"));
        this.map.remove((Object)Character.valueOf('\u0001'));
        Iterator itr = this.map.entries().iterator();
        while (itr.hasNext()) {
            CharObjectMap.PrimitiveEntry entry = (CharObjectMap.PrimitiveEntry)itr.next();
            Assert.assertNotNull((Object)Character.valueOf(entry.key()));
            Assert.assertNotNull((Object)entry.value());
            itr.remove();
        }
        Assert.assertTrue((boolean)this.map.isEmpty());
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void putNewMappingShouldSucceed() {
        Value v = new Value("v");
        char key = '\u0001';
        Assert.assertNull((Object)this.map.put(key, (Object)v));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey(key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
        Assert.assertEquals((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void putNewMappingShouldSucceed_mapApi() {
        Value v = new Value("v");
        Character key = Character.valueOf('\u0001');
        Assert.assertNull((Object)this.map.put(key, (Object)v));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey((Object)key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
        Assert.assertEquals((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldReplaceValue() {
        Value v1 = new Value("v1");
        char key = '\u0001';
        Assert.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assert.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey(key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assert.assertEquals((Object)v2, (Object)this.map.get(key));
    }

    @Test
    public void putShouldReplaceValue_mapApi() {
        Value v1 = new Value("v1");
        Character key = Character.valueOf('\u0001');
        Assert.assertNull((Object)this.map.put(key, (Object)v1));
        Value v2 = new Value("v2");
        Assert.assertSame((Object)v1, (Object)this.map.put(key, (Object)v2));
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.containsKey((Object)key));
        Assert.assertTrue((boolean)this.map.containsValue((Object)v2));
        Assert.assertEquals((Object)v2, (Object)this.map.get((Object)key));
    }

    @Test
    public void putShouldGrowMap() {
        for (char key = '\u0000'; key < '\u00ff'; key = (char)(key + '\u0001')) {
            Value v = new Value(Character.toString(key));
            Assert.assertNull((Object)this.map.put(key, (Object)v));
            Assert.assertEquals((long)(key + '\u0001'), (long)this.map.size());
            Assert.assertTrue((boolean)this.map.containsKey(key));
            Assert.assertTrue((boolean)this.map.containsValue((Object)v));
            Assert.assertEquals((Object)v, (Object)this.map.get(key));
        }
    }

    @Test
    public void putShouldGrowMap_mapApi() {
        for (char key = '\u0000'; key < '\u00ff'; key = (char)(key + '\u0001')) {
            Character okey = Character.valueOf(key);
            Value v = new Value(Character.toString(key));
            Assert.assertNull((Object)this.map.put(okey, (Object)v));
            Assert.assertEquals((long)(key + '\u0001'), (long)this.map.size());
            Assert.assertTrue((boolean)this.map.containsKey((Object)okey));
            Assert.assertTrue((boolean)this.map.containsValue((Object)v));
            Assert.assertEquals((Object)v, (Object)this.map.get((Object)okey));
        }
    }

    @Test
    public void negativeKeyShouldSucceed() {
        Value v = new Value("v");
        this.map.put('\ufffd', (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertEquals((Object)v, (Object)this.map.get('\ufffd'));
    }

    @Test
    public void negativeKeyShouldSucceed_mapApi() {
        Value v = new Value("v");
        this.map.put(Character.valueOf('\ufffd'), (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertEquals((Object)v, (Object)this.map.get((Object)Character.valueOf('\ufffd')));
    }

    @Test
    public void removeMissingValueShouldReturnNull() {
        Assert.assertNull((Object)this.map.remove('\u0001'));
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void removeMissingValueShouldReturnNull_mapApi() {
        Assert.assertNull((Object)this.map.remove((Object)Character.valueOf('\u0001')));
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void removeShouldReturnPreviousValue() {
        Value v = new Value("v");
        char key = '\u0001';
        this.map.put(key, (Object)v);
        Assert.assertSame((Object)v, (Object)this.map.remove(key));
    }

    @Test
    public void removeShouldReturnPreviousValue_mapApi() {
        Value v = new Value("v");
        Character key = Character.valueOf('\u0001');
        this.map.put(key, (Object)v);
        Assert.assertSame((Object)v, (Object)this.map.remove((Object)key));
    }

    @Test
    public void noFreeSlotsShouldRehash() {
        for (char i = '\u0000'; i < '\n'; i = (char)(i + '\u0001')) {
            this.map.put(i, (Object)new Value(Character.toString(i)));
            this.map.remove(i);
            Assert.assertEquals((long)0L, (long)this.map.size());
        }
        Value v = new Value("v");
        char key = '\u0001';
        this.map.put(key, (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertSame((Object)v, (Object)this.map.get(key));
    }

    @Test
    public void noFreeSlotsShouldRehash_mapApi() {
        for (char i = '\u0000'; i < '\n'; i = (char)(i + '\u0001')) {
            this.map.put(i, (Object)new Value(Character.toString(i)));
            this.map.remove((Object)Character.valueOf(i));
            Assert.assertEquals((long)0L, (long)this.map.size());
        }
        Value v = new Value("v");
        Character key = Character.valueOf('\u0001');
        this.map.put(key, (Object)v);
        Assert.assertEquals((long)1L, (long)this.map.size());
        Assert.assertSame((Object)v, (Object)this.map.get((Object)key));
    }

    @Test
    public void putAllShouldSucceed() {
        CharObjectHashMap other = new CharObjectHashMap();
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assert.assertEquals((long)3L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get(k1));
        Assert.assertSame((Object)v2, (Object)this.map.get(k2));
        Assert.assertSame((Object)v3, (Object)this.map.get(k3));
    }

    @Test
    public void putAllShouldSucceed_mapApi() {
        CharObjectHashMap other = new CharObjectHashMap();
        Character k1 = Character.valueOf('\u0001');
        Character k2 = Character.valueOf('\u0002');
        Character k3 = Character.valueOf('\u0003');
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, (Object)v1);
        other.put(k2, (Object)v2);
        other.put(k3, (Object)v3);
        this.map.putAll((Map)other);
        Assert.assertEquals((long)3L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assert.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assert.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void putAllWithJavaMapShouldSucceed_mapApi() {
        HashMap<Character, Value> other = new HashMap<Character, Value>();
        Character k1 = Character.valueOf('\u0001');
        Character k2 = Character.valueOf('\u0002');
        Character k3 = Character.valueOf('\u0003');
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        other.put(k1, v1);
        other.put(k2, v2);
        other.put(k3, v3);
        this.map.putAll(other);
        Assert.assertEquals((long)3L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get((Object)k1));
        Assert.assertSame((Object)v2, (Object)this.map.get((Object)k2));
        Assert.assertSame((Object)v3, (Object)this.map.get((Object)k3));
    }

    @Test
    public void clearShouldSucceed() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put('\u0001', (Object)v1);
        this.map.put('\u0002', (Object)v2);
        this.map.put('\u0003', (Object)v3);
        this.map.clear();
        Assert.assertEquals((long)0L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValueShouldFindNull() {
        this.map.put('\u0001', (Object)new Value("v1"));
        this.map.put('\u0002', null);
        this.map.put('\u0003', (Object)new Value("v2"));
        Assert.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindNull_mapApi() {
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v1"));
        this.map.put(Character.valueOf('\u0002'), null);
        this.map.put(Character.valueOf('\u0003'), (Object)new Value("v2"));
        Assert.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    public void containsValueShouldFindInstance() {
        Value v = new Value("v1");
        this.map.put('\u0001', (Object)new Value("v2"));
        this.map.put('\u0002', (Object)new Value("v3"));
        this.map.put('\u0003', (Object)v);
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindInstance_mapApi() {
        Value v = new Value("v1");
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v2"));
        this.map.put(Character.valueOf('\u0002'), (Object)new Value("v3"));
        this.map.put(Character.valueOf('\u0003'), (Object)v);
        Assert.assertTrue((boolean)this.map.containsValue((Object)v));
    }

    @Test
    public void containsValueShouldFindEquivalentValue() {
        this.map.put('\u0001', (Object)new Value("v1"));
        this.map.put('\u0002', (Object)new Value("v2"));
        this.map.put('\u0003', (Object)new Value("v3"));
        Assert.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueShouldFindEquivalentValue_mapApi() {
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v1"));
        this.map.put(Character.valueOf('\u0002'), (Object)new Value("v2"));
        this.map.put(Character.valueOf('\u0003'), (Object)new Value("v3"));
        Assert.assertTrue((boolean)this.map.containsValue((Object)new Value("v2")));
    }

    @Test
    public void containsValueNotFindMissingValue() {
        this.map.put('\u0001', (Object)new Value("v1"));
        this.map.put('\u0002', (Object)new Value("v2"));
        this.map.put('\u0003', (Object)new Value("v3"));
        Assert.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void containsValueNotFindMissingValue_mapApi() {
        this.map.put(Character.valueOf('\u0001'), (Object)new Value("v1"));
        this.map.put(Character.valueOf('\u0002'), (Object)new Value("v2"));
        this.map.put(Character.valueOf('\u0003'), (Object)new Value("v3"));
        Assert.assertFalse((boolean)this.map.containsValue((Object)new Value("v4")));
    }

    @Test
    public void iteratorShouldTraverseEntries() {
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        char k4 = '\u0004';
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet found = new HashSet();
        for (Map.Entry entry : this.map.entrySet()) {
            Assert.assertTrue((boolean)found.add(entry.getKey()));
        }
        Assert.assertEquals((long)3L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(Character.valueOf(k1)));
        Assert.assertTrue((boolean)found.contains(Character.valueOf(k2)));
        Assert.assertTrue((boolean)found.contains(Character.valueOf(k3)));
    }

    @Test
    public void keysShouldBeReturned() {
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        char k4 = '\u0004';
        this.map.put(k1, (Object)new Value("v1"));
        this.map.put(k2, (Object)new Value("v2"));
        this.map.put(k3, (Object)new Value("v3"));
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        Set keys = this.map.keySet();
        Assert.assertEquals((long)3L, (long)keys.size());
        HashSet<Character> expected = new HashSet<Character>();
        expected.add(Character.valueOf(k1));
        expected.add(Character.valueOf(k2));
        expected.add(Character.valueOf(k3));
        HashSet<Character> found = new HashSet<Character>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            char key = ((Character)iterator.next()).charValue();
            Assert.assertTrue((boolean)found.add(Character.valueOf(key)));
        }
        Assert.assertEquals(expected, found);
    }

    @Test
    public void valuesShouldBeReturned() {
        char k1 = '\u0001';
        char k2 = '\u0002';
        char k3 = '\u0003';
        char k4 = '\u0004';
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put(k1, (Object)v1);
        this.map.put(k2, (Object)v2);
        this.map.put(k3, (Object)v3);
        this.map.put(k4, (Object)new Value("v4"));
        this.map.remove(k4);
        HashSet<Value> expected = new HashSet<Value>();
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        HashSet actual = new HashSet(this.map.values());
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void mapShouldSupportHashingConflicts() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                CharObjectHashMap map = new CharObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put((char)(i * mod), (Object)"");
                }
            }
        }
    }

    @Test
    public void mapShouldSupportHashingConflicts_mapApi() {
        for (int mod = 0; mod < 10; ++mod) {
            for (int sz = 1; sz <= 101; sz += 2) {
                CharObjectHashMap map = new CharObjectHashMap(sz);
                for (int i = 0; i < 100; ++i) {
                    map.put(Character.valueOf((char)(i * mod)), (Object)"");
                }
            }
        }
    }

    @Test
    public void hashcodeEqualsTest() {
        CharObjectHashMap map1 = new CharObjectHashMap();
        CharObjectHashMap map2 = new CharObjectHashMap();
        Random rnd = new Random(0L);
        while (map1.size() < 100) {
            char key = (char)rnd.nextInt(100);
            map1.put(key, (Object)Character.valueOf(key));
            map2.put(key, (Object)Character.valueOf(key));
        }
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        Assert.assertEquals((Object)map1, (Object)map2);
        Set keys = map1.keySet();
        Character removed = null;
        Iterator iter = keys.iterator();
        for (int ix = 0; iter.hasNext() && ix < 50; ++ix) {
            removed = (Character)iter.next();
        }
        map2.remove(removed);
        Assert.assertFalse((boolean)map1.equals((Object)map2));
        map2.put(removed, (Object)removed);
        Assert.assertEquals((Object)map1, (Object)map2);
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        map2.put('d', (Object)Character.valueOf('d'));
        Assert.assertFalse((boolean)map1.equals((Object)map2));
        map2.clear();
        for (Character key : map1.keySet()) {
            map2.put(key, (Object)key);
        }
        Assert.assertEquals((long)map1.hashCode(), (long)map2.hashCode());
        Assert.assertEquals((Object)map1, (Object)map2);
    }

    @Test
    public void fuzzTest() {
        char key;
        int i;
        Random rnd = new Random(0L);
        int baseSize = 1000;
        int startTableSize = 1105;
        CharObjectHashMap map = new CharObjectHashMap(startTableSize);
        HashMap<Character, Character> goodMap = new HashMap<Character, Character>();
        for (i = 0; i < baseSize / 4; ++i) {
            key = (char)rnd.nextInt(baseSize);
            Assert.assertEquals((Object)goodMap.put(Character.valueOf(key), Character.valueOf(key)), (Object)map.put(key, (Object)Character.valueOf(key)));
            key = (char)(rnd.nextInt(baseSize) * 17);
            Assert.assertEquals((Object)goodMap.put(Character.valueOf(key), Character.valueOf(key)), (Object)map.put(key, (Object)Character.valueOf(key)));
        }
        for (i = 0; i < baseSize * 1000; ++i) {
            key = (char)rnd.nextInt(baseSize);
            if (rnd.nextDouble() >= 0.2) {
                Assert.assertEquals((Object)goodMap.put(Character.valueOf(key), Character.valueOf(key)), (Object)map.put(key, (Object)Character.valueOf(key)));
                continue;
            }
            Assert.assertEquals(goodMap.remove(Character.valueOf(key)), (Object)map.remove(key));
        }
        int removeSize = map.size() / 2;
        while (removeSize > 0) {
            key = (char)rnd.nextInt(baseSize);
            boolean found = goodMap.containsKey(Character.valueOf(key));
            Assert.assertEquals((Object)found, (Object)map.containsKey(key));
            Assert.assertEquals(goodMap.remove(Character.valueOf(key)), (Object)map.remove(key));
            if (!found) continue;
            --removeSize;
        }
        Assert.assertEquals((long)goodMap.size(), (long)map.size());
        Object[] goodKeys = goodMap.keySet().toArray(new Character[goodMap.size()]);
        Arrays.sort(goodKeys);
        Object[] keys = map.keySet().toArray(new Character[map.size()]);
        Arrays.sort(keys);
        for (int i2 = 0; i2 < goodKeys.length; ++i2) {
            Assert.assertEquals((Object)goodKeys[i2], (Object)keys[i2]);
        }
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            char key2 = ((Character)objectArray[j]).charValue();
            Assert.assertEquals(goodMap.remove(Character.valueOf(key2)), (Object)map.remove(key2));
        }
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void valuesIteratorRemove() {
        Value v1 = new Value("v1");
        Value v2 = new Value("v2");
        Value v3 = new Value("v3");
        this.map.put('\u0001', (Object)v1);
        this.map.put('\u0002', (Object)v2);
        this.map.put('\u0003', (Object)v3);
        Iterator it = this.map.values().iterator();
        Assert.assertSame((Object)v1, it.next());
        Assert.assertSame((Object)v2, it.next());
        it.remove();
        Assert.assertSame((Object)v3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)2L, (long)this.map.size());
        Assert.assertSame((Object)v1, (Object)this.map.get('\u0001'));
        Assert.assertNull((Object)this.map.get('\u0002'));
        Assert.assertSame((Object)v3, (Object)this.map.get('\u0003'));
        it = this.map.values().iterator();
        Assert.assertSame((Object)v1, it.next());
        Assert.assertSame((Object)v3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    private static class Value {
        private final String name;

        Value(String name) {
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

