/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DomainNameMappingTest {
    @Test(expected=NullPointerException.class)
    public void testNullDefaultValueInDeprecatedApi() {
        new DomainNameMapping(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDomainNamePatternsAreForbiddenInDeprecatedApi() {
        new DomainNameMapping((Object)"NotFound").add(null, (Object)"Some value");
    }

    @Test(expected=NullPointerException.class)
    public void testNullValuesAreForbiddenInDeprecatedApi() {
        new DomainNameMapping((Object)"NotFound").add("Some key", null);
    }

    @Test
    public void testDefaultValueInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound");
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("not-existing"));
        mapping.add("*.netty.io", (Object)"Netty");
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("not-existing"));
    }

    @Test
    public void testStrictEqualityInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads");
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", (Object)mapping.map("downloads.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("x.y.z.netty.io"));
    }

    @Test
    public void testWildcardMatchesAnyPrefixInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("*.netty.io", (Object)"Netty");
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("downloads.netty.io"));
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("x.y.z.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("netty.io.x"));
    }

    @Test
    public void testFirstMatchWinsInDeprecatedApi() {
        Assert.assertEquals((Object)"Netty", (Object)new DomainNameMapping((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").map("downloads.netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", (Object)new DomainNameMapping((Object)"NotFound").add("downloads.netty.io", (Object)"Netty-Downloads").add("*.netty.io", (Object)"Netty").map("downloads.netty.io"));
    }

    @Test
    public void testToStringInDeprecatedApi() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads");
        Assert.assertEquals((Object)"DomainNameMapping(default: NotFound, map: {*.netty.io=Netty, downloads.netty.io=Netty-Downloads})", (Object)mapping.toString());
    }

    @Test(expected=NullPointerException.class)
    public void testNullDefaultValue() {
        new DomainNameMappingBuilder(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDomainNamePatternsAreForbidden() {
        new DomainNameMappingBuilder((Object)"NotFound").add(null, (Object)"Some value");
    }

    @Test(expected=NullPointerException.class)
    public void testNullValuesAreForbidden() {
        new DomainNameMappingBuilder((Object)"NotFound").add("Some key", null);
    }

    @Test
    public void testDefaultValue() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("not-existing"));
    }

    @Test
    public void testStrictEquality() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build();
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", (Object)mapping.map("downloads.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("x.y.z.netty.io"));
    }

    @Test
    public void testWildcardMatchesAnyPrefix() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("netty.io"));
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("downloads.netty.io"));
        Assert.assertEquals((Object)"Netty", (Object)mapping.map("x.y.z.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map("netty.io.x"));
    }

    @Test
    public void testFirstMatchWins() {
        Assert.assertEquals((Object)"Netty", (Object)new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build().map("downloads.netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", (Object)new DomainNameMappingBuilder((Object)"NotFound").add("downloads.netty.io", (Object)"Netty-Downloads").add("*.netty.io", (Object)"Netty").build().map("downloads.netty.io"));
    }

    @Test
    public void testToString() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Download").build();
        Assert.assertEquals((Object)"ImmutableDomainNameMapping(default: NotFound, map: {*.netty.io=Netty, downloads.netty.io=Netty-Download})", (Object)mapping.toString());
    }

    @Test
    public void testAsMap() {
        DomainNameMapping mapping = new DomainNameMapping((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads");
        Map entries = mapping.asMap();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)"Netty", entries.get("netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", entries.get("downloads.netty.io"));
    }

    @Test
    public void testAsMapWithImmutableDomainNameMapping() {
        DomainNameMapping mapping = new DomainNameMappingBuilder((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build();
        Map entries = mapping.asMap();
        Assert.assertEquals((long)2L, (long)entries.size());
        Assert.assertEquals((Object)"Netty", entries.get("netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", entries.get("downloads.netty.io"));
    }
}

