/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.DefaultAttributeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAttributeMapTest {
    private DefaultAttributeMap map;

    @Before
    public void setup() {
        this.map = new DefaultAttributeMap();
    }

    @Test
    public void testMapExists() {
        Assert.assertNotNull((Object)this.map);
    }

    @Test
    public void testGetSetString() {
        AttributeKey key = AttributeKey.valueOf((String)"Nothing");
        Attribute one = this.map.attr(key);
        Assert.assertSame((Object)one, (Object)this.map.attr(key));
        one.setIfAbsent((Object)"Whoohoo");
        Assert.assertSame((Object)"Whoohoo", (Object)one.get());
        one.setIfAbsent((Object)"What");
        Assert.assertNotSame((Object)"What", (Object)one.get());
        one.remove();
        Assert.assertNull((Object)one.get());
    }

    @Test
    public void testGetSetInt() {
        AttributeKey key = AttributeKey.valueOf((String)"Nada");
        Attribute one = this.map.attr(key);
        Assert.assertSame((Object)one, (Object)this.map.attr(key));
        one.setIfAbsent((Object)3653);
        Assert.assertEquals((Object)3653, (Object)one.get());
        one.setIfAbsent((Object)1);
        Assert.assertNotSame((Object)1, (Object)one.get());
        one.remove();
        Assert.assertNull((Object)one.get());
    }

    @Test
    public void testSetRemove() {
        AttributeKey key = AttributeKey.valueOf((String)"key");
        Attribute attr = this.map.attr(key);
        attr.set((Object)1);
        Assert.assertSame((Object)1, (Object)attr.getAndRemove());
        Attribute attr2 = this.map.attr(key);
        attr2.set((Object)2);
        Assert.assertSame((Object)2, (Object)attr2.get());
        Assert.assertNotSame((Object)attr, (Object)attr2);
    }

    @Test
    public void testHasAttrRemoved() {
        AttributeKey key;
        int i;
        AttributeKey[] keys = new AttributeKey[20];
        for (i = 0; i < 20; ++i) {
            keys[i] = AttributeKey.valueOf((String)Integer.toString(i));
        }
        for (i = 10; i < 20; ++i) {
            this.map.attr(keys[i]);
        }
        for (i = 0; i < 10; ++i) {
            this.map.attr(keys[i]);
        }
        for (i = 10; i < 20; ++i) {
            key = AttributeKey.valueOf((String)Integer.toString(i));
            Assert.assertTrue((boolean)this.map.hasAttr(key));
            this.map.attr(key).remove();
            Assert.assertFalse((boolean)this.map.hasAttr(key));
        }
        for (i = 0; i < 10; ++i) {
            key = AttributeKey.valueOf((String)Integer.toString(i));
            Assert.assertTrue((boolean)this.map.hasAttr(key));
            this.map.attr(key).remove();
            Assert.assertFalse((boolean)this.map.hasAttr(key));
        }
    }

    @Test
    public void testGetAndSetWithNull() {
        AttributeKey key = AttributeKey.valueOf((String)"key");
        Attribute attr = this.map.attr(key);
        attr.set((Object)1);
        Assert.assertSame((Object)1, (Object)attr.getAndSet(null));
        Attribute attr2 = this.map.attr(key);
        attr2.set((Object)2);
        Assert.assertSame((Object)2, (Object)attr2.get());
        Assert.assertSame((Object)attr, (Object)attr2);
    }
}

