/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Random;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class AsciiStringCharacterTest {
    private static final Random r = new Random();

    @Test
    public void testContentEqualsIgnoreCase() {
        byte[] bytes = new byte[]{32, 97};
        AsciiString asciiString = new AsciiString(bytes, 1, 1, false);
        Assert.assertFalse((boolean)asciiString.contentEqualsIgnoreCase((CharSequence)"b"));
        Assert.assertFalse((boolean)asciiString.contentEqualsIgnoreCase((CharSequence)AsciiString.of((CharSequence)"b")));
    }

    @Test
    public void testGetBytesStringBuilder() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 65536; ++i) {
            b.append("e\u00e9a\u00e0");
        }
        String bString = b.toString();
        Charset[] charsets = CharsetUtil.values();
        for (int i = 0; i < charsets.length; ++i) {
            Charset charset = charsets[i];
            byte[] expected = bString.getBytes(charset);
            byte[] actual = new AsciiString((CharSequence)b, charset).toByteArray();
            Assert.assertArrayEquals((String)("failure for " + charset), (byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testGetBytesString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 65536; ++i) {
            b.append("e\u00e9a\u00e0");
        }
        String bString = b.toString();
        Charset[] charsets = CharsetUtil.values();
        for (int i = 0; i < charsets.length; ++i) {
            Charset charset = charsets[i];
            byte[] expected = bString.getBytes(charset);
            byte[] actual = new AsciiString((CharSequence)bString, charset).toByteArray();
            Assert.assertArrayEquals((String)("failure for " + charset), (byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void testGetBytesAsciiString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 65536; ++i) {
            b.append("e\u00e9a\u00e0");
        }
        String bString = b.toString();
        byte[] expected = bString.getBytes(CharsetUtil.ISO_8859_1);
        byte[] actual = new AsciiString((CharSequence)bString).toByteArray();
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testComparisonWithString() {
        String string = "shouldn't fail";
        AsciiString ascii = new AsciiString(string.toCharArray());
        Assert.assertEquals((Object)string, (Object)ascii.toString());
    }

    @Test
    public void subSequenceTest() {
        byte[] init = new byte[]{116, 104, 105, 115, 32, 105, 115, 32, 97, 32, 116, 101, 115, 116};
        AsciiString ascii = new AsciiString(init);
        int start = 2;
        int end = init.length;
        AsciiString sub1 = ascii.subSequence(2, end, false);
        AsciiString sub2 = ascii.subSequence(2, end, true);
        Assert.assertEquals((long)sub1.hashCode(), (long)sub2.hashCode());
        Assert.assertEquals((Object)sub1, (Object)sub2);
        for (int i = 2; i < end; ++i) {
            Assert.assertEquals((long)init[i], (long)sub1.byteAt(i - 2));
        }
    }

    @Test
    public void testContains() {
        String b;
        String[] falseLhs = new String[]{null, "a", "aa", "aaa"};
        String[] falseRhs = new String[]{null, "b", "ba", "baa"};
        for (int i = 0; i < falseLhs.length; ++i) {
            for (int j = 0; j < falseRhs.length; ++j) {
                AsciiStringCharacterTest.assertContains(falseLhs[i], falseRhs[i], false, false);
            }
        }
        AsciiStringCharacterTest.assertContains("", "", true, true);
        AsciiStringCharacterTest.assertContains("AsfdsF", "", true, true);
        AsciiStringCharacterTest.assertContains("", "b", false, false);
        AsciiStringCharacterTest.assertContains("a", "a", true, true);
        AsciiStringCharacterTest.assertContains("a", "b", false, false);
        AsciiStringCharacterTest.assertContains("a", "A", false, true);
        String a = b = "xyz";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        a = "a" + b;
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        a = b + "a";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        a = "a" + b + "a";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        b = "xYz";
        a = "xyz";
        AsciiStringCharacterTest.assertContains(a, b, false, true);
        b = "xYz";
        a = "xyzxxxXyZ" + b + "aaa";
        AsciiStringCharacterTest.assertContains(a, b, true, true);
        b = "foOo";
        a = "fooofoO";
        AsciiStringCharacterTest.assertContains(a, b, false, true);
        b = "Content-Equals: 10000";
        a = "content-equals: 1000";
        AsciiStringCharacterTest.assertContains(a, b, false, false);
        a = a + "0";
        AsciiStringCharacterTest.assertContains(a, b, false, true);
    }

    private static void assertContains(String a, String b, boolean caseSensitiveEquals, boolean caseInsenstaiveEquals) {
        Assert.assertEquals((Object)caseSensitiveEquals, (Object)AsciiString.contains((CharSequence)a, (CharSequence)b));
        Assert.assertEquals((Object)caseInsenstaiveEquals, (Object)AsciiString.containsIgnoreCase((CharSequence)a, (CharSequence)b));
    }

    @Test
    public void testCaseSensitivity() {
        int i;
        for (i = 0; i < 32; ++i) {
            AsciiStringCharacterTest.doCaseSensitivity(i);
        }
        int min = i;
        int max = 4000;
        int len = r.nextInt(4000 - min + 1) + min;
        AsciiStringCharacterTest.doCaseSensitivity(len);
    }

    private static void doCaseSensitivity(int len) {
        int upperA = 65;
        int upperZ = 90;
        int upperToLower = 32;
        byte[] lowerCaseBytes = new byte[len];
        StringBuilder upperCaseBuilder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char upper = (char)(r.nextInt(26) + 65);
            upperCaseBuilder.append(upper);
            lowerCaseBytes[i] = (byte)(upper + 32);
        }
        String upperCaseString = upperCaseBuilder.toString();
        String lowerCaseString = new String(lowerCaseBytes);
        AsciiString lowerCaseAscii = new AsciiString(lowerCaseBytes, false);
        AsciiString upperCaseAscii = new AsciiString((CharSequence)upperCaseString);
        String errorString = "len: " + len;
        int upperCaseExpected = upperCaseAscii.hashCode();
        Assert.assertEquals((String)errorString, (long)upperCaseExpected, (long)AsciiString.hashCode((CharSequence)upperCaseBuilder));
        Assert.assertEquals((String)errorString, (long)upperCaseExpected, (long)AsciiString.hashCode((CharSequence)upperCaseString));
        Assert.assertEquals((String)errorString, (long)upperCaseExpected, (long)upperCaseAscii.hashCode());
        int lowerCaseExpected = lowerCaseAscii.hashCode();
        Assert.assertEquals((String)errorString, (long)lowerCaseExpected, (long)AsciiString.hashCode((CharSequence)lowerCaseAscii));
        Assert.assertEquals((String)errorString, (long)lowerCaseExpected, (long)AsciiString.hashCode((CharSequence)lowerCaseString));
        Assert.assertEquals((String)errorString, (long)lowerCaseExpected, (long)lowerCaseAscii.hashCode());
        int expectedCaseInsensitive = lowerCaseAscii.hashCode();
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)AsciiString.hashCode((CharSequence)upperCaseBuilder));
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)AsciiString.hashCode((CharSequence)upperCaseString));
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)AsciiString.hashCode((CharSequence)lowerCaseString));
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)AsciiString.hashCode((CharSequence)lowerCaseAscii));
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)AsciiString.hashCode((CharSequence)upperCaseAscii));
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)lowerCaseAscii.hashCode());
        Assert.assertEquals((String)errorString, (long)expectedCaseInsensitive, (long)upperCaseAscii.hashCode());
        Assert.assertEquals((String)errorString, (long)lowerCaseAscii.hashCode(), (long)AsciiString.hashCode((CharSequence)upperCaseString));
        Assert.assertEquals((String)errorString, (long)upperCaseAscii.hashCode(), (long)AsciiString.hashCode((CharSequence)lowerCaseString));
    }

    @Test
    public void caseInsensitiveHasherCharBuffer() {
        String s1 = new String("TRANSFER-ENCODING");
        char[] array = new char[128];
        int offset = 100;
        for (int i = 0; i < s1.length(); ++i) {
            array[100 + i] = s1.charAt(i);
        }
        CharBuffer buffer = CharBuffer.wrap(array, 100, s1.length());
        Assert.assertEquals((long)AsciiString.hashCode((CharSequence)s1), (long)AsciiString.hashCode((CharSequence)buffer));
    }

    @Test
    public void testBooleanUtilityMethods() {
        Assert.assertTrue((boolean)new AsciiString(new byte[]{1}).parseBoolean());
        Assert.assertFalse((boolean)AsciiString.EMPTY_STRING.parseBoolean());
        Assert.assertFalse((boolean)new AsciiString(new byte[]{0}).parseBoolean());
        Assert.assertTrue((boolean)new AsciiString(new byte[]{5}).parseBoolean());
        Assert.assertTrue((boolean)new AsciiString(new byte[]{2, 0}).parseBoolean());
    }

    @Test
    public void testEqualsIgnoreCase() {
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, null), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, (CharSequence)"foo"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"bar", null), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"bar"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"Foo", (CharSequence)"foobar"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"foobar", (CharSequence)"Foo"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)new AsciiString((CharSequence)"fOo")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)new AsciiString((CharSequence)"fOo")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)"bAr"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)new AsciiString((CharSequence)"FoO"), (CharSequence)new AsciiString((CharSequence)"bAr")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)new AsciiString((CharSequence)"bAr")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIndexOfIgnoreCase() {
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCase(null, (CharSequence)"abc", (int)1));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"abc", null, (int)1));
        Assert.assertEquals((long)0L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assert.assertEquals((long)2L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assert.assertEquals((long)1L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assert.assertEquals((long)5L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assert.assertEquals((long)2L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assert.assertEquals((long)2L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"abc", (CharSequence)"", (int)9));
        Assert.assertEquals((long)0L, (long)AsciiString.indexOfIgnoreCase((CharSequence)"\u00e3abaabaa", (CharSequence)"\u00c3", (int)0));
    }

    @Test
    public void testIndexOfIgnoreCaseAscii() {
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCaseAscii(null, (CharSequence)"abc", (int)1));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"abc", null, (int)1));
        Assert.assertEquals((long)0L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"", (CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"A", (int)0));
        Assert.assertEquals((long)2L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)0));
        Assert.assertEquals((long)1L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"AB", (int)0));
        Assert.assertEquals((long)5L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)3));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)9));
        Assert.assertEquals((long)2L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"B", (int)-1));
        Assert.assertEquals((long)2L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"aabaabaa", (CharSequence)"", (int)2));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOfIgnoreCaseAscii((CharSequence)"abc", (CharSequence)"", (int)9));
    }

    @Test
    public void testTrim() {
        Assert.assertEquals((Object)"", (Object)AsciiString.EMPTY_STRING.trim().toString());
        Assert.assertEquals((Object)"abc", (Object)new AsciiString((CharSequence)"  abc").trim().toString());
        Assert.assertEquals((Object)"abc", (Object)new AsciiString((CharSequence)"abc  ").trim().toString());
        Assert.assertEquals((Object)"abc", (Object)new AsciiString((CharSequence)"  abc  ").trim().toString());
    }

    @Test
    public void testIndexOfChar() {
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOf(null, (char)'a', (int)0));
        Assert.assertEquals((long)-1L, (long)AsciiString.of((CharSequence)"").indexOf('a', 0));
        Assert.assertEquals((long)-1L, (long)AsciiString.of((CharSequence)"abc").indexOf('d', 0));
        Assert.assertEquals((long)-1L, (long)AsciiString.of((CharSequence)"aabaabaa").indexOf('A', 0));
        Assert.assertEquals((long)0L, (long)AsciiString.of((CharSequence)"aabaabaa").indexOf('a', 0));
        Assert.assertEquals((long)1L, (long)AsciiString.of((CharSequence)"aabaabaa").indexOf('a', 1));
        Assert.assertEquals((long)3L, (long)AsciiString.of((CharSequence)"aabaabaa").indexOf('a', 2));
        Assert.assertEquals((long)3L, (long)AsciiString.of((CharSequence)"aabdabaa").indexOf('d', 1));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd", 1, 2).indexOf('c', 0));
        Assert.assertEquals((long)2L, (long)new AsciiString((CharSequence)"abcd", 1, 3).indexOf('d', 2));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd", 1, 2).indexOf('b', 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd", 0, 2).indexOf('c', 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd", 1, 3).indexOf('a', 0));
    }

    @Test
    public void testIndexOfCharSequence() {
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"abcd", 0));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"abc", 0));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"bcd", 0));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"bc", 0));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcdabcd").indexOf((CharSequence)"bcd", 0));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd", 1, 2).indexOf((CharSequence)"bc", 0));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd", 1, 3).indexOf((CharSequence)"bcd", 0));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcdabcd", 4, 4).indexOf((CharSequence)"bcd", 0));
        Assert.assertEquals((long)3L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"345", 3));
        Assert.assertEquals((long)3L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"345", 0));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"", 0));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"", 1));
        Assert.assertEquals((long)3L, (long)new AsciiString((CharSequence)"abcd", 1, 3).indexOf((CharSequence)"", 4));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd").indexOf((CharSequence)"abcde", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcdbc").indexOf((CharSequence)"bce", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd", 1, 3).indexOf((CharSequence)"abc", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd", 1, 2).indexOf((CharSequence)"bd", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"345", 4));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abc", 3));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abc", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abcdefghi", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").indexOf((CharSequence)"abcdefghi", 4));
    }

    @Test
    public void testStaticIndexOfChar() {
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOf(null, (char)'a', (int)0));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOf((CharSequence)"", (char)'a', (int)0));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOf((CharSequence)"abc", (char)'d', (int)0));
        Assert.assertEquals((long)-1L, (long)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'A', (int)0));
        Assert.assertEquals((long)0L, (long)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'a', (int)0));
        Assert.assertEquals((long)1L, (long)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'a', (int)1));
        Assert.assertEquals((long)3L, (long)AsciiString.indexOf((CharSequence)"aabaabaa", (char)'a', (int)2));
        Assert.assertEquals((long)3L, (long)AsciiString.indexOf((CharSequence)"aabdabaa", (char)'d', (int)1));
    }

    @Test
    public void testLastIndexOfCharSequence() {
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"abcd", 0));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"abc", 4));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"bcd", 4));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"bc", 4));
        Assert.assertEquals((long)5L, (long)new AsciiString((CharSequence)"abcdabcd").lastIndexOf((CharSequence)"bcd", 10));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd", 1, 2).lastIndexOf((CharSequence)"bc", 2));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd", 1, 3).lastIndexOf((CharSequence)"bcd", 3));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcdabcd", 4, 4).lastIndexOf((CharSequence)"bcd", 4));
        Assert.assertEquals((long)3L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"345", 3));
        Assert.assertEquals((long)3L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"345", 6));
        Assert.assertEquals((long)0L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"", 0));
        Assert.assertEquals((long)1L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"", 1));
        Assert.assertEquals((long)3L, (long)new AsciiString((CharSequence)"abcd", 1, 3).lastIndexOf((CharSequence)"", 4));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd").lastIndexOf((CharSequence)"abcde", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcdbc").lastIndexOf((CharSequence)"bce", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd", 1, 3).lastIndexOf((CharSequence)"abc", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"abcd", 1, 2).lastIndexOf((CharSequence)"bd", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"345", 2));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abc", 3));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abc", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abcdefghi", 0));
        Assert.assertEquals((long)-1L, (long)new AsciiString((CharSequence)"012345").lastIndexOf((CharSequence)"abcdefghi", 4));
    }

    @Test
    public void testReplace() {
        AsciiString abcd = new AsciiString((CharSequence)"abcd");
        Assert.assertEquals((Object)new AsciiString((CharSequence)"adcd"), (Object)abcd.replace('b', 'd'));
        Assert.assertEquals((Object)new AsciiString((CharSequence)"dbcd"), (Object)abcd.replace('a', 'd'));
        Assert.assertEquals((Object)new AsciiString((CharSequence)"abca"), (Object)abcd.replace('d', 'a'));
        Assert.assertSame((Object)abcd, (Object)abcd.replace('x', 'a'));
        Assert.assertEquals((Object)new AsciiString((CharSequence)"cc"), (Object)new AsciiString((CharSequence)"abcd", 1, 2).replace('b', 'c'));
        Assert.assertEquals((Object)new AsciiString((CharSequence)"bb"), (Object)new AsciiString((CharSequence)"abcd", 1, 2).replace('c', 'b'));
        Assert.assertEquals((Object)new AsciiString((CharSequence)"bddd"), (Object)new AsciiString((CharSequence)"abcdc", 1, 4).replace('c', 'd'));
        Assert.assertEquals((Object)new AsciiString((CharSequence)"xbcxd"), (Object)new AsciiString((CharSequence)"abcada", 0, 5).replace('a', 'x'));
    }

    @Test
    public void testSubStringHashCode() {
        Assert.assertEquals((long)AsciiString.hashCode((CharSequence)"123"), (long)AsciiString.hashCode((CharSequence)"a123".substring(1)));
    }

    @Test
    public void testIndexOf() {
        AsciiString foo = AsciiString.of((CharSequence)"This is a test");
        int i1 = foo.indexOf(' ', 0);
        Assert.assertEquals((long)4L, (long)i1);
        int i2 = foo.indexOf(' ', i1 + 1);
        Assert.assertEquals((long)7L, (long)i2);
        int i3 = foo.indexOf(' ', i2 + 1);
        Assert.assertEquals((long)9L, (long)i3);
        Assert.assertTrue((i3 + 1 < foo.length() ? 1 : 0) != 0);
        int i4 = foo.indexOf(' ', i3 + 1);
        Assert.assertEquals((long)i4, (long)-1L);
    }
}

