/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.IMongoConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.Feature;
import java.util.List;
import java.util.Objects;

public abstract class AbstractMongo {
    protected static <T extends IMongoConfig> void applyDefaultOptions(T config, List<String> ret) {
        if (!config.version().enabled(Feature.NO_HTTP_INTERFACE_ARG)) {
            ret.add("--nohttpinterface");
        }
    }

    protected static <T extends IMongoConfig> void applyNet(T config, List<String> ret) {
        Net net = config.net();
        ret.add("--port");
        ret.add("" + net.getPort());
        if (net.isIpv6()) {
            ret.add("--ipv6");
        }
        if (net.getBindIp() != null) {
            ret.add("--bind_ip");
            if (Objects.equals("localhost", net.getBindIp()) && config.version().enabled(Feature.NO_BIND_IP_TO_LOCALHOST)) {
                ret.add("127.0.0.1");
            } else {
                ret.add(net.getBindIp());
            }
        }
    }
}

