/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config.processlistener;

import de.flapdoodle.embed.mongo.config.processlistener.IMongoProcessListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ProcessListener {
    private ProcessListener() {
    }

    public static IMongoProcessListener join(IMongoProcessListener ... listener) {
        return new ProcessListenerCollection(Arrays.asList(listener));
    }

    public static IMongoProcessListener join(List<IMongoProcessListener> listener) {
        return new ProcessListenerCollection(listener);
    }

    static class ProcessListenerCollection
    implements IMongoProcessListener {
        private final List<IMongoProcessListener> _listener;

        public ProcessListenerCollection(List<IMongoProcessListener> listener) {
            this._listener = new ArrayList<IMongoProcessListener>(listener);
        }

        @Override
        public void onBeforeProcessStart(File dbDir, boolean dbDirIsTemp) {
            for (IMongoProcessListener listener : this._listener) {
                listener.onBeforeProcessStart(dbDir, dbDirIsTemp);
            }
        }

        @Override
        public void onAfterProcessStop(File dbDir, boolean dbDirIsTemp) {
            for (IMongoProcessListener listener : this._listener) {
                listener.onAfterProcessStop(dbDir, dbDirIsTemp);
            }
        }
    }
}

