/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Nullable;
import cn.taketoday.util.PlaceholderResolver;
import cn.taketoday.util.PropertyPlaceholderHandler;

public abstract class SystemPropertyUtils {
    public static String resolvePlaceholders(String text) {
        return SystemPropertyUtils.resolvePlaceholders(text, false);
    }

    public static String resolvePlaceholders(String text, boolean ignoreUnresolvablePlaceholders) {
        if (text.isEmpty()) {
            return text;
        }
        PropertyPlaceholderHandler shared = PropertyPlaceholderHandler.shared(ignoreUnresolvablePlaceholders);
        return shared.replacePlaceholders(text, new SystemPropertyPlaceholderResolver(text));
    }

    private record SystemPropertyPlaceholderResolver(String text) implements PlaceholderResolver
    {
        @Override
        @Nullable
        public String resolvePlaceholder(String placeholderName) {
            try {
                String propVal = System.getProperty(placeholderName);
                if (propVal == null) {
                    propVal = System.getenv(placeholderName);
                }
                return propVal;
            }
            catch (Throwable ex) {
                System.err.println("Could not resolve placeholder '" + placeholderName + "' in [" + this.text + "] as system property: " + ex);
                return null;
            }
        }
    }
}

