/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public final class SingletonIterator<E>
implements Iterator<E> {
    private boolean hasNext = true;
    final E element;

    public SingletonIterator(E element) {
        this.element = element;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.element;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (this.hasNext) {
            action.accept(this.element);
            this.hasNext = false;
        }
    }
}

