/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ArrayIterator;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class ArrayHolder<E>
implements Supplier<E[]>,
Iterable<E>,
RandomAccess {
    private E[] array;
    @Nullable
    private final Class<E> elementClass;
    @Nullable
    private final IntFunction<E[]> arrayGenerator;

    public ArrayHolder() {
        this(null, null);
    }

    public ArrayHolder(@Nullable Class<E> elementClass, @Nullable IntFunction<E[]> arrayGenerator) {
        this.elementClass = elementClass;
        this.arrayGenerator = arrayGenerator;
    }

    @SafeVarargs
    public final void set(E ... array) {
        this.array = array;
    }

    public void sort() {
        this.sort(AnnotationAwareOrderComparator.INSTANCE);
    }

    public void sort(Comparator<E> comparator) {
        if (this.array != null && this.array.length > 1) {
            Arrays.sort(this.array, comparator);
        }
    }

    @SafeVarargs
    public final void add(E ... array) {
        ArrayList objects = new ArrayList(array.length);
        CollectionUtils.addAll(objects, (Object[])this.array);
        CollectionUtils.addAll(objects, (Object[])array);
        this.set(objects);
    }

    public void addAll(Collection<E> list) {
        ArrayList objects = new ArrayList(list.size());
        CollectionUtils.addAll(objects, (Object[])this.array);
        CollectionUtils.addAll(objects, list);
        this.set(objects);
    }

    public void set(@Nullable Collection<E> list) {
        if (CollectionUtils.isEmpty(list)) {
            this.array = null;
        } else if (this.arrayGenerator != null) {
            this.set(list.toArray(this.arrayGenerator.apply(list.size())));
        } else {
            Class<Object> elementClass = this.elementClass;
            if (elementClass == null) {
                E firstElement = CollectionUtils.firstElement(list);
                Assert.state(firstElement != null, "list is empty");
                elementClass = firstElement.getClass();
            }
            this.set(list.toArray((Object[])Array.newInstance(elementClass, list.size())));
        }
    }

    @Override
    @Nullable
    public E[] get() {
        return this.array;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.isPresent()) {
            return new ArrayIterator<E>(this.array);
        }
        return Collections.emptyIterator();
    }

    public void ifPresent(Consumer<E[]> action) {
        if (this.isPresent()) {
            action.accept(this.array);
        }
    }

    public void ifPresentOrElse(Consumer<E[]> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.array);
        } else {
            emptyAction.run();
        }
    }

    @Nullable
    public <U> U map(Function<? super E[], ? extends U> mapper) {
        return this.map(mapper, null);
    }

    @Nullable
    public <U> U map(Function<? super E[], ? extends U> mapper, @Nullable Supplier<U> emptySupplier) {
        if (this.isEmpty()) {
            if (emptySupplier != null) {
                return emptySupplier.get();
            }
            return null;
        }
        return mapper.apply(this.array);
    }

    public Stream<E> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Arrays.stream(this.array);
    }

    public E[] orElse(E[] other) {
        return this.isPresent() ? this.array : other;
    }

    public E[] orElseGet(Supplier<E[]> supplier) {
        return this.isPresent() ? this.array : supplier.get();
    }

    public E[] orElseThrow() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("No value present");
        }
        return this.array;
    }

    public Optional<E[]> getOptional() {
        return Optional.ofNullable(this.array);
    }

    public E[] getRequired() {
        return this.getRequired("Array is not available");
    }

    public E[] getRequired(String message) {
        if (this.array == null) {
            throw new IllegalStateException(message);
        }
        return this.array;
    }

    public <X extends Throwable> E[] orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.array;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean isPresent() {
        E[] array = this.array;
        return array != null && array.length != 0;
    }

    public boolean isEmpty() {
        E[] array = this.array;
        return array == null || array.length == 0;
    }

    public void clear() {
        this.array = null;
    }

    public String toString() {
        return this.isPresent() ? Arrays.toString(this.array) : "[]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ArrayHolder)) return false;
        ArrayHolder that = (ArrayHolder)o;
        if (!Arrays.equals(this.array, that.array)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    @SafeVarargs
    public static <E> ArrayHolder<E> valueOf(E ... array) {
        ArrayHolder<E> holder = new ArrayHolder<E>();
        holder.set(array);
        return holder;
    }

    public static <E> ArrayHolder<E> valueOf(List<E> list) {
        ArrayHolder<E> holder = new ArrayHolder<E>();
        holder.set(list);
        return holder;
    }

    public static <E> ArrayHolder<E> copyOf(ArrayHolder<E> holder) {
        ArrayHolder<E> arrayHolder = new ArrayHolder<E>();
        if (ObjectUtils.isNotEmpty(holder.array)) {
            arrayHolder.set(Arrays.copyOf(holder.array, holder.array.length));
        }
        return arrayHolder;
    }

    public static <E> ArrayHolder<E> forClass(@Nullable Class<E> elementClass) {
        return new ArrayHolder<E>(elementClass, null);
    }

    public static <E> ArrayHolder<E> forGenerator(@Nullable IntFunction<E[]> arrayGenerator) {
        return new ArrayHolder<E>(null, arrayGenerator);
    }
}

