/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.reflect;

import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.MethodAccessorGetterMethod;
import cn.taketoday.reflect.MethodInvoker;
import cn.taketoday.reflect.ReflectiveGetterMethod;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public interface GetterMethod {
    public Object get(Object var1);

    @Nullable
    default public Method getReadMethod() {
        return null;
    }

    public static GetterMethod fromField(Field field) {
        Method readMethod = ReflectionUtils.getReadMethod(field);
        if (readMethod == null) {
            return GetterMethod.fromReflective(field);
        }
        return GetterMethod.fromMethod(readMethod);
    }

    public static GetterMethod fromMethod(Method method) {
        MethodInvoker accessor = MethodInvoker.fromMethod(method);
        return GetterMethod.fromMethod(accessor);
    }

    public static GetterMethod fromMethod(MethodInvoker invoker) {
        return new MethodAccessorGetterMethod(invoker);
    }

    public static GetterMethod fromReflective(Field field) {
        ReflectionUtils.makeAccessible(field);
        return new ReflectiveGetterMethod(field);
    }
}

