/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.JavaLoggingFactory;
import cn.taketoday.logging.Log4j2LoggerFactory;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.Slf4jLoggerFactory;

public abstract class LoggerFactory {
    public static final String LOG_TYPE_SYSTEM_PROPERTY = "logger.factory";
    private static final LoggerFactory factory = LoggerFactory.createFactory();

    protected abstract Logger createLogger(String var1);

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        return factory.createLogger(name);
    }

    private static synchronized LoggerFactory createFactory() {
        if (factory == null) {
            String type = System.getProperty(LOG_TYPE_SYSTEM_PROPERTY);
            if (type != null) {
                try {
                    return (LoggerFactory)Class.forName(type).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.println("Could not find valid log-type from system property 'logger.factory', value '" + type + "'");
                }
            }
            try {
                return new Slf4jLoggerFactory();
            }
            catch (Throwable throwable) {
                try {
                    return new Log4j2LoggerFactory();
                }
                catch (Throwable throwable2) {
                    return new JavaLoggingFactory();
                }
            }
        }
        return factory;
    }
}

