/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.Level;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.MessageFormatter;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.LogRecord;
import java.util.stream.Stream;

final class JavaLoggingLogger
extends Logger {
    private final java.util.logging.Logger logger;

    public JavaLoggingLogger(java.util.logging.Logger logger, boolean debugEnabled) {
        super(debugEnabled);
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.debugEnabled && this.logger.isLoggable(java.util.logging.Level.FINEST);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.SEVERE);
    }

    private java.util.logging.Level levelToJavaLevel(Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Level.TRACE -> java.util.logging.Level.FINEST;
            case Level.DEBUG -> java.util.logging.Level.FINER;
            case Level.WARN -> java.util.logging.Level.WARNING;
            case Level.ERROR -> java.util.logging.Level.SEVERE;
            case Level.INFO -> java.util.logging.Level.INFO;
        };
    }

    @Override
    protected void logInternal(Level level, Object message, Throwable t) {
        java.util.logging.Level levelToJavaLevel = this.levelToJavaLevel(level);
        if (this.logger.isLoggable(levelToJavaLevel)) {
            LogRecord rec;
            if (message instanceof LogRecord) {
                rec = (LogRecord)message;
            } else {
                rec = new LocationResolvingLogRecord(levelToJavaLevel, String.valueOf(message));
                rec.setLoggerName(this.getName());
                rec.setResourceBundleName(this.logger.getResourceBundleName());
                rec.setResourceBundle(this.logger.getResourceBundle());
                rec.setThrown(t);
            }
            this.logger.log(rec);
        }
    }

    @Override
    protected void logInternal(Level level, String format, Throwable t, Object[] args) {
        java.util.logging.Level levelToJavaLevel = this.levelToJavaLevel(level);
        if (this.logger.isLoggable(levelToJavaLevel)) {
            String message = MessageFormatter.format(format, args);
            LocationResolvingLogRecord rec = new LocationResolvingLogRecord(levelToJavaLevel, message);
            rec.setLoggerName(this.getName());
            rec.setResourceBundleName(this.logger.getResourceBundleName());
            rec.setResourceBundle(this.logger.getResourceBundle());
            rec.setThrown(t);
            this.logger.log(rec);
        }
    }

    private static class LocationResolvingLogRecord
    extends LogRecord {
        private volatile boolean resolved;

        public LocationResolvingLogRecord(java.util.logging.Level level, String msg) {
            super(level, msg);
        }

        @Override
        public String getSourceClassName() {
            if (!this.resolved) {
                this.resolve();
            }
            return super.getSourceClassName();
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            super.setSourceClassName(sourceClassName);
            this.resolved = true;
        }

        @Override
        public String getSourceMethodName() {
            if (!this.resolved) {
                this.resolve();
            }
            return super.getSourceMethodName();
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            super.setSourceMethodName(sourceMethodName);
            this.resolved = true;
        }

        private Optional<StackWalker.StackFrame> eatStackFrame(Stream<StackWalker.StackFrame> stream) {
            Predicate<StackWalker.StackFrame> loggerPredicate = new Predicate<StackWalker.StackFrame>(){
                boolean found = false;

                @Override
                public boolean test(StackWalker.StackFrame stackFrame) {
                    String className = stackFrame.getClassName();
                    if (Logger.FQCN.equals(className)) {
                        this.found = true;
                        return false;
                    }
                    return this.found;
                }
            };
            return stream.filter(loggerPredicate).findFirst();
        }

        private void resolve() {
            StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(this::eatStackFrame).ifPresent(stackFrame -> {
                this.setSourceClassName(stackFrame.getClassName());
                this.setSourceMethodName(stackFrame.getMethodName());
            });
        }

        protected Object writeReplace() {
            LogRecord serialized = new LogRecord(this.getLevel(), this.getMessage());
            serialized.setLoggerName(this.getLoggerName());
            serialized.setResourceBundle(this.getResourceBundle());
            serialized.setResourceBundleName(this.getResourceBundleName());
            serialized.setSourceClassName(this.getSourceClassName());
            serialized.setSourceMethodName(this.getSourceMethodName());
            serialized.setSequenceNumber(this.getSequenceNumber());
            serialized.setParameters(this.getParameters());
            serialized.setLongThreadID(this.getLongThreadID());
            serialized.setInstant(this.getInstant());
            serialized.setThrown(this.getThrown());
            return serialized;
        }
    }
}

