/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.AntPathMatcher;
import cn.taketoday.core.PathMatcher;
import cn.taketoday.core.io.AbstractResource;
import cn.taketoday.core.io.ClassPathResource;
import cn.taketoday.core.io.DefaultResourceLoader;
import cn.taketoday.core.io.FileSystemResource;
import cn.taketoday.core.io.JarEntryResource;
import cn.taketoday.core.io.JarResource;
import cn.taketoday.core.io.PatternResourceLoader;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceConsumer;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.io.UrlResource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ExceptionUtils;
import cn.taketoday.util.ResourceUtils;
import cn.taketoday.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ResolvedModule;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathMatchingPatternResourceLoader
implements PatternResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PathMatchingPatternResourceLoader.class);
    private static final Set<String> systemModuleNames = ModuleFinder.ofSystem().findAll().stream().map(moduleReference -> moduleReference.descriptor().name()).collect(Collectors.toSet());
    private static final Predicate<ResolvedModule> isNotSystemModule = Predicate.not(resolvedModule -> systemModuleNames.contains(resolvedModule.name()));
    private PathMatcher pathMatcher = new AntPathMatcher();
    private final ResourceLoader resourceLoader;

    public PathMatchingPatternResourceLoader() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingPatternResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public PathMatchingPatternResourceLoader(@Nullable ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.resourceLoader.getClassLoader();
    }

    public ResourceLoader getRootLoader() {
        return this.resourceLoader;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    @Override
    @NonNull
    public Resource getResource(String location) {
        return this.resourceLoader.getResource(location);
    }

    @Override
    public Set<Resource> getResources(String locationPattern) throws IOException {
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>();
        this.scan(locationPattern, result::add);
        return result;
    }

    @Override
    public void scan(String locationPattern, ResourceConsumer consumer) throws IOException {
        Assert.notNull((Object)locationPattern, "Location pattern must not be null");
        if (locationPattern.startsWith("classpath*:")) {
            String locationPatternWithoutPrefix = locationPattern.substring("classpath*:".length());
            this.findAllModulePathResources(locationPatternWithoutPrefix, consumer);
            if (this.getPathMatcher().isPattern(locationPatternWithoutPrefix)) {
                this.findPathMatchingResources(locationPattern, consumer);
            } else {
                this.findAllClassPathResources(locationPatternWithoutPrefix, consumer);
            }
        } else {
            int prefixEnd = locationPattern.startsWith("war:") ? locationPattern.indexOf("*/") : locationPattern.indexOf(58);
            if (this.getPathMatcher().isPattern(prefixEnd > -1 ? locationPattern.substring(prefixEnd + 1) : locationPattern)) {
                this.findPathMatchingResources(locationPattern, consumer);
            } else {
                Resource resource = this.getResource(locationPattern);
                consumer.accept(resource);
            }
        }
    }

    protected void findAllClassPathResources(String location, ResourceConsumer consumer) throws IOException {
        String path = PathMatchingPatternResourceLoader.stripLeadingSlash(location);
        this.doFindAllClassPathResources(path, consumer);
    }

    protected void doFindAllClassPathResources(String path, ResourceConsumer consumer) throws IOException {
        ClassLoader cl = this.getClassLoader();
        if (StringUtils.isEmpty(path)) {
            this.addAllClassLoaderJarRoots(cl, consumer);
        } else {
            Enumeration<URL> resourceUrls;
            Enumeration<URL> enumeration = resourceUrls = cl != null ? cl.getResources(path) : ClassLoader.getSystemResources(path);
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                consumer.accept(this.convertClassLoaderURL(url));
            }
        }
    }

    protected Resource convertClassLoaderURL(URL url) {
        return ResourceUtils.getResource(url);
    }

    protected void addAllClassLoaderJarRoots(@Nullable ClassLoader classLoader, ResourceConsumer consumer) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                for (URL url : urlClassLoader.getURLs()) {
                    try {
                        JarEntryResource jarResource;
                        String path = url.getPath();
                        if (!path.endsWith(".jar") || !(jarResource = new JarEntryResource(path)).exists()) continue;
                        consumer.accept(jarResource);
                    }
                    catch (IOException ex) {
                        log.debug("Cannot search for matching files underneath [{}] because it cannot be converted to a valid 'jar:' URL: {}", (Object)url, (Object)ex.getMessage());
                    }
                }
            }
            catch (Exception ex) {
                log.debug("Cannot introspect jar files since ClassLoader [{}] does not support 'getURLs()': {}", (Object)classLoader, (Object)ex);
            }
        }
        if (classLoader == ClassLoader.getSystemClassLoader()) {
            this.addClassPathManifestEntries(consumer);
        }
        if (classLoader != null) {
            try {
                this.addAllClassLoaderJarRoots(classLoader.getParent(), consumer);
            }
            catch (Exception ex) {
                log.debug("Cannot introspect jar files in parent ClassLoader since [{}] does not support 'getParent()': {}", classLoader, ex.toString(), ex);
            }
        }
    }

    protected void addClassPathManifestEntries(ResourceConsumer consumer) {
        try {
            String javaClassPath = System.getProperty("java.class.path");
            String separator = System.getProperty("path.separator");
            for (String path : StringUtils.delimitedListToStringArray(javaClassPath, separator)) {
                try {
                    if (!path.endsWith(".jar")) continue;
                    File jarFile = new File(path);
                    String filePath = jarFile.getAbsolutePath();
                    int prefixIndex = filePath.indexOf(58);
                    if (prefixIndex == 1) {
                        filePath = StringUtils.capitalize(filePath);
                    }
                    String url = new StringBuilder(filePath.length() + 11).append("jar:file:").append(filePath).append("!/").toString();
                    JarEntryResource jarResource = new JarEntryResource(new URL(url), jarFile, "");
                    consumer.accept(jarResource);
                }
                catch (MalformedURLException ex) {
                    log.debug("Cannot search for matching files underneath [{}] because it cannot be converted to a valid 'jar:' URL: {}", path, ex.getMessage(), ex);
                }
            }
        }
        catch (Exception ex) {
            log.debug("Failed to evaluate 'java.class.path' manifest entries: ", (Throwable)ex);
        }
    }

    protected void findPathMatchingResources(String locationPattern, ResourceConsumer consumer) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        this.scan(rootDirPath, rootDirResource -> this.rootDirResource(subPattern, rootDirResource, consumer));
    }

    protected void rootDirResource(String subPattern, Resource rootResource, ResourceConsumer consumer) throws IOException {
        if (rootResource instanceof JarResource) {
            this.doFindPathMatchingJarResources((JarResource)rootResource, subPattern, consumer);
        } else if (rootResource instanceof ClassPathResource) {
            Resource originalResource = ((ClassPathResource)rootResource).getOriginalResource();
            this.rootDirResource(subPattern, originalResource, consumer);
        } else {
            this.doFindPathMatchingFileResources(rootResource, subPattern, consumer);
        }
    }

    protected String determineRootDir(String location) {
        int prefixEnd = location.indexOf(58) + 1;
        int rootDirEnd = location.length();
        PathMatcher pathMatcher = this.getPathMatcher();
        while (rootDirEnd > prefixEnd && pathMatcher.isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFindPathMatchingJarResources(JarResource rootDirResource, String subPattern, ResourceConsumer consumer) throws IOException {
        URL rootDirURL = rootDirResource.getURL();
        JarURLConnection jarCon = (JarURLConnection)rootDirURL.openConnection();
        ResourceUtils.useCachesIfNecessary(jarCon);
        JarEntry jarEntry = jarCon.getJarEntry();
        String rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        boolean closeJarFile = !jarCon.getUseCaches();
        JarFile jarFile = rootDirResource.getJarFile();
        try {
            if (log.isDebugEnabled()) {
                String jarFileUrl = jarCon.getJarFileURL().toExternalForm();
                log.trace("Looking for matching resources in jar file [{}]", (Object)jarFileUrl);
            }
            if (!"".equals(rootEntryPath) && !StringUtils.matchesLast(rootEntryPath, '/')) {
                rootEntryPath = rootEntryPath.concat("/");
            }
            PathMatcher pathMatcher = this.getPathMatcher();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(rootEntryPath) || !pathMatcher.match(subPattern, relativePath = entryPath.substring(rootEntryPath.length()))) continue;
                Resource relative = rootDirResource.createRelative(relativePath);
                consumer.accept(relative);
            }
        }
        finally {
            if (closeJarFile) {
                jarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFindPathMatchingFileResources(Resource rootDirResource, String subPattern, ResourceConsumer consumer) throws IOException {
        URI rootDirUri;
        try {
            rootDirUri = rootDirResource.getURI();
            String scheme = rootDirUri.getScheme();
            String path2 = rootDirUri.getPath();
            if ("resource".equals(scheme) && path2.length() > 1 && path2.endsWith("/")) {
                path2 = path2.substring(0, path2.length() - 1);
                rootDirUri = new URI(scheme, path2, rootDirUri.getFragment());
            }
        }
        catch (Exception ex) {
            log.info("Failed to resolve %s as URI: {}", (Object)rootDirResource, (Object)ex);
            return;
        }
        try (FileSystem fileSystem = null;){
            Object rootDir;
            Path rootPath = null;
            if (rootDirUri.isAbsolute() && !rootDirUri.isOpaque()) {
                try {
                    try {
                        rootPath = Path.of(rootDirUri);
                    }
                    catch (FileSystemNotFoundException ex) {
                        fileSystem = FileSystems.newFileSystem(rootDirUri, Collections.emptyMap(), ClassUtils.getDefaultClassLoader());
                        rootPath = Path.of(rootDirUri);
                    }
                }
                catch (Exception ex) {
                    log.debug("Failed to resolve {} in file system: {}", (Object)rootDirUri, (Object)ex);
                }
            }
            if (rootPath == null) {
                rootPath = Path.of(rootDirResource.getFile().getAbsolutePath(), new String[0]);
            }
            if (!((String)(rootDir = StringUtils.cleanPath(rootPath.toString()))).endsWith("/")) {
                rootDir = (String)rootDir + "/";
            }
            String resourcePattern = (String)rootDir + StringUtils.cleanPath(subPattern);
            Predicate<Path> isMatchingFile = path -> Files.isRegularFile(path, new LinkOption[0]) && this.pathMatcher.match(resourcePattern, StringUtils.cleanPath(path.toString()));
            if (log.isDebugEnabled()) {
                log.trace("Searching directory [{}] for files matching pattern [{}]", (Object)rootPath.toAbsolutePath(), (Object)subPattern);
            }
            try (Stream<Path> files = Files.walk(rootPath, new FileVisitOption[0]);){
                files.filter(isMatchingFile).sorted().forEach(file -> {
                    try {
                        consumer.accept(new FileSystemResource((Path)file));
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.sneakyThrow(e);
                    }
                });
            }
            catch (Exception ex) {
                log.debug("Failed to complete search in directory [{}] for files matching pattern [{}]: {}", rootPath.toAbsolutePath(), subPattern, ex);
                throw ex;
            }
        }
    }

    protected void findAllModulePathResources(String locationPattern, ResourceConsumer consumer) throws IOException {
        LinkedHashSet result = null;
        if (log.isDebugEnabled()) {
            result = new LinkedHashSet(16);
            consumer = consumer.andThen(result::add);
        }
        String resourcePattern = PathMatchingPatternResourceLoader.stripLeadingSlash(locationPattern);
        PathMatcher pathMatcher = this.getPathMatcher();
        boolean pattern = pathMatcher.isPattern(resourcePattern);
        Iterator moduleIterator = ModuleLayer.boot().configuration().modules().stream().filter(isNotSystemModule).iterator();
        while (moduleIterator.hasNext()) {
            ResolvedModule resolvedModule = (ResolvedModule)moduleIterator.next();
            try {
                ModuleReader moduleReader = resolvedModule.reference().open();
                try {
                    Stream<String> names = moduleReader.list();
                    try {
                        Iterator iterator = names.iterator();
                        while (iterator.hasNext()) {
                            String name = (String)iterator.next();
                            if (pattern) {
                                if (!pathMatcher.match(resourcePattern, name)) continue;
                                PathMatchingPatternResourceLoader.acceptResource(moduleReader, name, consumer);
                                continue;
                            }
                            if (!resourcePattern.equals(name)) continue;
                            PathMatchingPatternResourceLoader.acceptResource(moduleReader, name, consumer);
                        }
                    }
                    finally {
                        if (names == null) continue;
                        names.close();
                    }
                }
                finally {
                    if (moduleReader == null) continue;
                    moduleReader.close();
                }
            }
            catch (IOException ex) {
                log.debug("Failed to read contents of module [{}]", (Object)resolvedModule, (Object)ex);
                throw ex;
            }
        }
        if (log.isDebugEnabled()) {
            log.trace("Resolved module-path location pattern [{}] to resources {}", (Object)resourcePattern, (Object)result);
        }
    }

    private static void acceptResource(ModuleReader moduleReader, String name, ResourceConsumer consumer) throws IOException {
        AbstractResource resource;
        try {
            Optional<URI> uriOptional = moduleReader.find(name);
            if (!uriOptional.isPresent()) {
                return;
            }
            URI uri = uriOptional.get();
            resource = "file".equals(uri.getScheme()) ? new FileSystemResource(uri.getPath()) : UrlResource.from(uri);
        }
        catch (Exception ex) {
            log.debug("Failed to find resource [{}] in module path", (Object)name, (Object)ex);
            return;
        }
        consumer.accept(resource);
    }

    private static String stripLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

