/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.env.PropertySource;
import cn.taketoday.lang.Nullable;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class PropertySources
implements Iterable<PropertySource<?>> {
    private final CopyOnWriteArrayList<PropertySource<?>> propertySourceList = new CopyOnWriteArrayList();

    public PropertySources() {
    }

    public PropertySources(PropertySources propertySources) {
        for (PropertySource<?> propertySource : propertySources) {
            this.addLast(propertySource);
        }
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    @Override
    public Spliterator<PropertySource<?>> spliterator() {
        return this.propertySourceList.spliterator();
    }

    public Stream<PropertySource<?>> stream() {
        return this.propertySourceList.stream();
    }

    public boolean contains(String name) {
        for (PropertySource<?> propertySource : this.propertySourceList) {
            if (!propertySource.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PropertySource<?> get(String name) {
        for (PropertySource<?> propertySource : this.propertySourceList) {
            if (!propertySource.getName().equals(name)) continue;
            return propertySource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(PropertySource<?> propertySource) {
        CopyOnWriteArrayList<PropertySource<?>> copyOnWriteArrayList = this.propertySourceList;
        synchronized (copyOnWriteArrayList) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(0, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(PropertySource<?> propertySource) {
        CopyOnWriteArrayList<PropertySource<?>> copyOnWriteArrayList = this.propertySourceList;
        synchronized (copyOnWriteArrayList) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        CopyOnWriteArrayList<PropertySource<?>> copyOnWriteArrayList = this.propertySourceList;
        synchronized (copyOnWriteArrayList) {
            this.removeIfPresent(propertySource);
            int index = this.assertPresentAndGetIndex(relativePropertySourceName);
            this.addAtIndex(index, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        CopyOnWriteArrayList<PropertySource<?>> copyOnWriteArrayList = this.propertySourceList;
        synchronized (copyOnWriteArrayList) {
            this.removeIfPresent(propertySource);
            int index = this.assertPresentAndGetIndex(relativePropertySourceName);
            this.addAtIndex(index + 1, propertySource);
        }
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        return this.propertySourceList.indexOf(propertySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PropertySource<?> remove(String name) {
        CopyOnWriteArrayList<PropertySource<?>> copyOnWriteArrayList = this.propertySourceList;
        synchronized (copyOnWriteArrayList) {
            int index = this.propertySourceList.indexOf(PropertySource.named(name));
            return index != -1 ? this.propertySourceList.remove(index) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String name, PropertySource<?> propertySource) {
        CopyOnWriteArrayList<PropertySource<?>> copyOnWriteArrayList = this.propertySourceList;
        synchronized (copyOnWriteArrayList) {
            int index = this.assertPresentAndGetIndex(name);
            this.propertySourceList.set(index, propertySource);
        }
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public String toString() {
        return this.propertySourceList.toString();
    }

    protected void assertLegalRelativeAddition(String relativePropertySourceName, PropertySource<?> propertySource) {
        String newPropertySourceName = propertySource.getName();
        if (relativePropertySourceName.equals(newPropertySourceName)) {
            throw new IllegalArgumentException("PropertySource named '" + newPropertySourceName + "' cannot be added relative to itself");
        }
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        this.propertySourceList.remove(propertySource);
    }

    private void addAtIndex(int index, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(index, propertySource);
    }

    private int assertPresentAndGetIndex(String name) {
        int index = this.propertySourceList.indexOf(PropertySource.named(name));
        if (index == -1) {
            throw new IllegalArgumentException("PropertySource named '" + name + "' does not exist");
        }
        return index;
    }
}

