/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.env.IterablePropertyResolver;
import cn.taketoday.core.env.TypedPropertyResolver;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public class MapPropertyResolver
extends TypedPropertyResolver
implements IterablePropertyResolver {
    private static final Logger log = LoggerFactory.getLogger(MapPropertyResolver.class);
    @Nullable
    private final Map<String, Object> keyValues;

    public MapPropertyResolver(@Nullable Map keyValues) {
        this.keyValues = keyValues;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.keyValues != null) {
            return this.keyValues.containsKey(key);
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        if (this.keyValues != null) {
            Object value;
            if (log.isTraceEnabled()) {
                log.trace("Searching for key '{}' in map '{}'", (Object)key, (Object)this.keyValues);
            }
            if ((value = this.keyValues.get(key)) != null) {
                if (resolveNestedPlaceholders && value instanceof String) {
                    value = this.resolveNestedPlaceholders((String)value);
                }
                this.logKeyFound(key, value);
                return this.convertValueIfNecessary(value, targetValueType);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Could not find key '{}' in any property source", (Object)key);
        }
        return null;
    }

    protected void logKeyFound(String key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug("Found key '{}' with value of type {}", (Object)key, (Object)value.getClass().getSimpleName());
        }
    }

    @Override
    public Iterator<String> iterator() {
        if (this.keyValues != null) {
            return this.keyValues.keySet().iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        if (this.keyValues != null) {
            for (String key : this.keyValues.keySet()) {
                action.accept(key);
            }
        }
    }

    @Override
    public Spliterator<String> spliterator() {
        if (this.keyValues != null) {
            return this.keyValues.keySet().spliterator();
        }
        return Spliterators.emptySpliterator();
    }
}

