/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.codec;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.codec.AbstractDataBufferDecoder;
import cn.taketoday.core.codec.Hints;
import cn.taketoday.core.io.buffer.DataBuffer;
import cn.taketoday.core.io.buffer.DataBufferUtils;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.MimeType;
import cn.taketoday.util.MimeTypeUtils;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteBufferDecoder
extends AbstractDataBufferDecoder<ByteBuffer> {
    public ByteBufferDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return ByteBuffer.class.isAssignableFrom(elementType.toClass()) && super.canDecode(elementType, mimeType);
    }

    @Override
    public ByteBuffer decode(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        ByteBuffer result = dataBuffer.toByteBuffer();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Read " + dataBuffer.readableByteCount() + " bytes");
        }
        DataBufferUtils.release(dataBuffer);
        return result;
    }
}

