/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.DecoratingProxy;
import cn.taketoday.core.Ordered;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.annotation.Order;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.lang.reflect.AnnotatedElement;

public abstract class OrderUtils {
    private static final Object NOT_ANNOTATED = new Object();
    private static final String PRIORITY_ANNOTATION = "jakarta.annotation.Priority";
    private static final ConcurrentReferenceHashMap<AnnotatedElement, Object> orderCache = new ConcurrentReferenceHashMap(64);

    public static int getOrderOrLowest(AnnotatedElement annotated) {
        Integer order = OrderUtils.getOrder(annotated);
        return order == null ? Integer.MAX_VALUE : order;
    }

    public static int getOrderOrLowest(Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).getOrder();
        }
        if (obj instanceof AnnotatedElement) {
            return OrderUtils.getOrderOrLowest((AnnotatedElement)obj);
        }
        if (obj instanceof DecoratingProxy) {
            return OrderUtils.getOrderOrLowest(((DecoratingProxy)obj).getDecoratedClass());
        }
        return OrderUtils.getOrderOrLowest(ClassUtils.getUserClass(obj));
    }

    public static int getOrder(Class<?> type, int defaultOrder) {
        Integer order = OrderUtils.getOrder(type);
        return order != null ? order : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type, @Nullable Integer defaultOrder) {
        Integer order = OrderUtils.getOrder(type);
        return order != null ? order : defaultOrder;
    }

    @Nullable
    public static Integer getOrder(Class<?> type) {
        return OrderUtils.getOrder(type);
    }

    @Nullable
    public static Integer getOrder(AnnotatedElement element) {
        return OrderUtils.getOrderFromAnnotations(element, MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
    }

    @Nullable
    static Integer getOrderFromAnnotations(AnnotatedElement element, MergedAnnotations annotations) {
        if (!(element instanceof Class)) {
            return OrderUtils.findOrder(annotations);
        }
        Object cached = orderCache.get(element);
        if (cached != null) {
            return cached instanceof Integer ? (Integer)cached : null;
        }
        Integer result = OrderUtils.findOrder(annotations);
        orderCache.put(element, result != null ? result : NOT_ANNOTATED);
        return result;
    }

    @Nullable
    private static Integer findOrder(MergedAnnotations annotations) {
        MergedAnnotation<Order> orderAnnotation = annotations.get(Order.class);
        if (orderAnnotation.isPresent()) {
            return orderAnnotation.getInt("value");
        }
        MergedAnnotation priorityAnnotation = annotations.get(PRIORITY_ANNOTATION);
        if (priorityAnnotation.isPresent()) {
            return priorityAnnotation.getIntValue();
        }
        return null;
    }

    @Nullable
    public static Integer getPriority(Class<?> type) {
        return MergedAnnotations.from(type, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(PRIORITY_ANNOTATION).getValue(Integer.class).orElse(null);
    }
}

