/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.lang.Assert;
import java.util.function.Supplier;

public class NamedThreadLocal<T>
extends ThreadLocal<T> {
    private final String name;

    public NamedThreadLocal(String name) {
        Assert.hasText(name, "Name must not be empty");
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static <S> NamedThreadLocal<S> withInitial(String name, Supplier<? extends S> supplier) {
        final class Supplied
        extends NamedThreadLocal<S> {
            final /* synthetic */ Supplier val$supplier;

            Supplied(String string) {
                this.val$supplier = string;
                super(name);
            }

            @Override
            protected S initialValue() {
                return this.val$supplier.get();
            }
        }
        return new Supplied(name, supplier);
    }
}

