/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.ArraySizeTrimmer;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class CompositeStrategies<T>
implements ArraySizeTrimmer,
Iterable<T> {
    private final ArrayList<T> strategies;

    public CompositeStrategies() {
        this(new ArrayList());
    }

    public CompositeStrategies(int size) {
        this(new ArrayList(size));
    }

    CompositeStrategies(ArrayList<T> strategies) {
        this.strategies = strategies;
    }

    public void add(T resolver) {
        this.strategies.add(resolver);
    }

    @SafeVarargs
    public final void add(T ... resolver) {
        Collections.addAll(this.strategies, resolver);
    }

    public void add(List<T> resolvers) {
        this.strategies.addAll(resolvers);
        this.trimToSize();
    }

    public void set(@Nullable List<T> resolver) {
        this.strategies.clear();
        if (CollectionUtils.isNotEmpty(resolver)) {
            this.strategies.addAll(resolver);
            this.trimToSize();
        }
    }

    public boolean removeIf(Predicate<T> filter) {
        return this.strategies.removeIf(filter);
    }

    public boolean contains(Class<?> strategy) {
        for (T resolver : this.strategies) {
            if (strategy != resolver.getClass()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<T> getStrategies() {
        return this.strategies;
    }

    @Override
    public void trimToSize() {
        this.strategies.trimToSize();
    }

    @Override
    public Iterator<T> iterator() {
        return this.strategies.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.strategies.forEach((Consumer<T>)action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.strategies.spliterator();
    }
}

