/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.ArraySizeTrimmer;
import cn.taketoday.core.ParameterNameDiscoverer;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.lang.reflect.Executable;
import java.util.ArrayList;

public class CompositeParameterNameDiscoverer
extends ParameterNameDiscoverer
implements ArraySizeTrimmer {
    private final ArrayList<ParameterNameDiscoverer> discoverers = new ArrayList();

    public void addDiscoverer(ParameterNameDiscoverer ... discoverer) {
        CollectionUtils.addAll(this.discoverers, (Object[])discoverer);
        this.trimToSize();
    }

    @Override
    @Nullable
    public String[] getParameterNames(Executable executable) {
        for (ParameterNameDiscoverer discoverer : this.discoverers) {
            String[] parameterNames = discoverer.getParameterNames(executable);
            if (parameterNames == null) continue;
            return parameterNames;
        }
        return null;
    }

    @Override
    public void trimToSize() {
        this.discoverers.trimToSize();
    }
}

