/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree.analysis;

import cn.taketoday.bytecode.tree.JumpInsnNode;
import cn.taketoday.bytecode.tree.LabelNode;
import java.util.ArrayList;
import java.util.List;

final class Subroutine {
    public final LabelNode start;
    public final boolean[] localsUsed;
    public final List<JumpInsnNode> callers;

    Subroutine(LabelNode start, int maxLocals, JumpInsnNode caller) {
        this.start = start;
        this.localsUsed = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller);
    }

    Subroutine(Subroutine subroutine) {
        this.start = subroutine.start;
        this.localsUsed = (boolean[])subroutine.localsUsed.clone();
        this.callers = new ArrayList<JumpInsnNode>(subroutine.callers);
    }

    public boolean merge(Subroutine subroutine) {
        boolean changed = false;
        boolean[] localsUsed = this.localsUsed;
        boolean[] subroutineLocalsUsed = subroutine.localsUsed;
        for (int i = 0; i < localsUsed.length; ++i) {
            if (!subroutineLocalsUsed[i] || localsUsed[i]) continue;
            localsUsed[i] = true;
            changed = true;
        }
        if (subroutine.start == this.start) {
            List<JumpInsnNode> callers = this.callers;
            for (JumpInsnNode caller : subroutine.callers) {
                if (callers.contains(caller)) continue;
                callers.add(caller);
                changed = true;
            }
        }
        return changed;
    }
}

