/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.Block;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class UndeclaredThrowableTransformer
extends ClassEmitterTransformer {
    private final Type wrapper;

    public UndeclaredThrowableTransformer(Class<?> wrapper) {
        Constructor<?>[] cstructs;
        this.wrapper = Type.fromClass(wrapper);
        for (Constructor<?> cstruct : cstructs = wrapper.getConstructors()) {
            Class<?>[] types = cstruct.getParameterTypes();
            if (types.length != 1 || !types[0].equals(Throwable.class)) continue;
            return;
        }
        throw new IllegalArgumentException(wrapper + " does not have a single-arg constructor that takes a Throwable");
    }

    @Override
    public CodeEmitter beginMethod(int access, MethodSignature sig, final Type ... exceptions) {
        CodeEmitter e = super.beginMethod(access, sig, exceptions);
        if (Modifier.isAbstract(access) || sig.equals(MethodSignature.SIG_STATIC)) {
            return e;
        }
        return new CodeEmitter(e){
            private final Block handler;
            {
                super(wrap);
                this.handler = this.begin_block();
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                this.handler.end();
                EmitUtils.wrapUndeclaredThrowable(this, this.handler, exceptions, UndeclaredThrowableTransformer.this.wrapper);
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }
}

