/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.reflect;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.Objects;

public abstract class MethodDelegate {
    protected Object target;
    protected String eqMethod;

    public static <T> T createStatic(Class targetClass, String methodName, Class<T> iface) {
        Generator gen = new Generator();
        gen.setTargetClass(targetClass);
        gen.setMethodName(methodName);
        gen.setInterface(iface);
        return (T)gen.create();
    }

    public static <T> T create(Object target, String methodName, Class<T> iface) {
        Generator gen = new Generator();
        gen.setTarget(target);
        gen.setMethodName(methodName);
        gen.setInterface(iface);
        return (T)gen.create();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodDelegate)) {
            return false;
        }
        MethodDelegate that = (MethodDelegate)o;
        return Objects.equals(this.target, that.target) && Objects.equals(this.eqMethod, that.eqMethod);
    }

    public int hashCode() {
        return this.target.hashCode() ^ this.eqMethod.hashCode();
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract MethodDelegate newInstance(Object var1);

    public static class Generator
    extends AbstractClassGenerator {
        private static final Type METHOD_DELEGATE = Type.fromClass(MethodDelegate.class);
        private static final MethodSignature NEW_INSTANCE = new MethodSignature(METHOD_DELEGATE, "newInstance", Type.TYPE_OBJECT);
        private Object target;
        private Class targetClass;
        private String methodName;
        private Class iface;

        public Generator() {
            super(MethodDelegate.class);
        }

        public void setTarget(Object target) {
            this.target = target;
            this.setTargetClass(target.getClass());
        }

        public void setTargetClass(Class targetClass) {
            this.targetClass = targetClass;
            this.setNeighbor(targetClass);
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setInterface(Class iface) {
            this.iface = iface;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.targetClass);
        }

        public MethodDelegate create() {
            this.setNamePrefix(this.targetClass.getName());
            MethodDelegateKey key = new MethodDelegateKey(this.targetClass, this.methodName, this.iface);
            return (MethodDelegate)super.create(key);
        }

        protected Object firstInstance(Class type) {
            return ((MethodDelegate)ReflectionUtils.newInstance(type)).newInstance(this.target);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((MethodDelegate)instance).newInstance(this.target);
        }

        @Override
        public void generateClass(ClassVisitor v) throws NoSuchMethodException {
            MethodInfo methodInfo;
            boolean isStatic;
            Method proxy = ReflectionUtils.findFunctionalInterfaceMethod(this.iface);
            Method method = this.targetClass.getMethod(this.methodName, proxy.getParameterTypes());
            if (!proxy.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("incompatible return types");
            }
            if (this.target == null ^ (isStatic = Modifier.isStatic((methodInfo = MethodInfo.from(method)).getModifiers()))) {
                throw new IllegalArgumentException("Static method " + (isStatic ? "not " : "") + "expected");
            }
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), METHOD_DELEGATE, Type.array(Type.fromClass(this.iface)), "<cglibGenerated>");
            ce.declare_field(26, "eqMethod", Type.TYPE_STRING, null);
            EmitUtils.nullConstructor(ce);
            MethodInfo proxied = MethodInfo.from(this.iface.getDeclaredMethods()[0]);
            int modifiers = 1;
            if ((proxied.getModifiers() & 0x80) == 128) {
                modifiers |= 0x80;
            }
            CodeEmitter e = EmitUtils.beginMethod(ce, proxied, modifiers);
            e.loadThis();
            e.super_getfield("target", Type.TYPE_OBJECT);
            e.checkCast(methodInfo.getClassInfo().getType());
            e.loadArgs();
            e.invoke(methodInfo);
            e.returnValue();
            e.end_method();
            e = ce.beginMethod(1, NEW_INSTANCE, new Type[0]);
            e.new_instance_this();
            e.dup();
            e.dup2();
            e.invoke_constructor_this();
            e.getField("eqMethod");
            e.super_putfield("eqMethod", Type.TYPE_STRING);
            e.loadArg(0);
            e.super_putfield("target", Type.TYPE_OBJECT);
            e.returnValue();
            e.end_method();
            e = ce.begin_static();
            e.push(methodInfo.getSignature().toString());
            e.putField("eqMethod");
            e.returnValue();
            e.end_method();
            ce.endClass();
        }
    }

    record MethodDelegateKey(Class delegateClass, String methodName, Class iface) {
    }
}

