/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.reflect;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.reflect.FastConstructorAccessor;
import cn.taketoday.bytecode.reflect.FastMethodAccessor;
import cn.taketoday.bytecode.reflect.MethodAccessEmitter;
import cn.taketoday.lang.Constant;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public abstract class MethodAccess {
    private final Class type;

    protected MethodAccess(Class type) {
        this.type = type;
    }

    public abstract int getIndex(String var1, Class[] var2);

    public abstract int getIndex(Class[] var1);

    public abstract Object invoke(int var1, Object var2, Object[] var3) throws InvocationTargetException;

    public abstract Object newInstance(int var1, Object[] var2) throws InvocationTargetException;

    public abstract int getIndex(MethodSignature var1);

    public int getIndex(Method method) {
        return this.getIndex(MethodSignature.from(method));
    }

    public abstract int getMaxIndex();

    public Object invoke(String name, Class[] parameterTypes, Object obj, Object[] args) throws InvocationTargetException {
        return this.invoke(this.getIndex(name, parameterTypes), obj, args);
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(Constant.EMPTY_CLASSES), null);
    }

    public Object newInstance(Class[] parameterTypes, Object[] args) throws InvocationTargetException {
        return this.newInstance(this.getIndex(parameterTypes), args);
    }

    public FastMethodAccessor getMethod(Method method) {
        return new FastMethodAccessor(this, method);
    }

    public FastConstructorAccessor getConstructor(Constructor constructor) {
        return new FastConstructorAccessor(this, constructor);
    }

    public FastMethodAccessor getMethod(String name, Class[] parameterTypes) {
        try {
            return this.getMethod(this.type.getMethod(name, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public FastConstructorAccessor getConstructor(Class[] parameterTypes) {
        try {
            return this.getConstructor(this.type.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getDeclaringClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof MethodAccess && this.type.equals(((MethodAccess)o).type);
    }

    protected static String getSignatureWithoutReturnType(String name, Class[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append('(');
        for (Class parameterType : parameterTypes) {
            sb.append(Type.getDescriptor(parameterType));
        }
        sb.append(')');
        return sb.toString();
    }

    public static MethodAccess from(Class type) {
        return MethodAccess.from(type.getClassLoader(), type);
    }

    public static MethodAccess from(ClassLoader loader, Class type) {
        Generator gen = new Generator(type);
        gen.setClassLoader(loader);
        gen.setNeighbor(type);
        return gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private final Class<?> type;

        public Generator(Class<?> type) {
            super(MethodAccess.class);
            this.type = type;
        }

        public MethodAccess create() {
            this.setNamePrefix(this.type.getName());
            return (MethodAccess)super.create(this.type.getName());
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.type.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.type);
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new MethodAccessEmitter(v, this.getClassName(), this.type);
        }

        protected Object firstInstance(Class type) {
            return ReflectionUtils.newInstance(type, new Class[]{Class.class}, new Object[]{this.type});
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }
}

