/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.reflect;

import cn.taketoday.bytecode.reflect.FastMemberAccessor;
import cn.taketoday.bytecode.reflect.MethodAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FastMethodAccessor
extends FastMemberAccessor {
    FastMethodAccessor(MethodAccess fc, Method method) {
        super(fc, method, FastMethodAccessor.helper(fc, method));
    }

    private static int helper(MethodAccess fc, Method method) {
        int index = fc.getIndex(method);
        if (index < 0) {
            Class<?>[] types = method.getParameterTypes();
            System.err.println("hash=" + method.getName().hashCode() + " size=" + types.length);
            for (int i = 0; i < types.length; ++i) {
                System.err.println("  types[" + i + "]=" + types[i].getName());
            }
            throw new IllegalArgumentException("Cannot find method " + method);
        }
        return index;
    }

    public Class getReturnType() {
        return ((Method)this.member).getReturnType();
    }

    @Override
    public Class[] getParameterTypes() {
        return ((Method)this.member).getParameterTypes();
    }

    @Override
    public Class[] getExceptionTypes() {
        return ((Method)this.member).getExceptionTypes();
    }

    public Object invoke(Object obj, Object[] args) throws InvocationTargetException {
        return this.fc.invoke(this.index, obj, args);
    }

    public Method getJavaMethod() {
        return (Method)this.member;
    }
}

