/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.proxy.CallbackGenerator;
import java.lang.reflect.Modifier;
import java.util.List;

final class NoOpGenerator
implements CallbackGenerator {
    public static final NoOpGenerator INSTANCE = new NoOpGenerator();

    NoOpGenerator() {
    }

    public static boolean isBridge(int access) {
        return (0x40 & access) != 0;
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        for (Object object : methods) {
            MethodInfo method = (MethodInfo)object;
            if (!NoOpGenerator.isBridge(method.getModifiers()) && (!Modifier.isProtected(context.getOriginalModifiers(method)) || !Modifier.isPublic(method.getModifiers()))) continue;
            CodeEmitter e = EmitUtils.beginMethod(ce, method);
            e.loadThis();
            context.emitLoadArgsAndInvoke(e, method);
            e.returnValue();
            e.end_method();
        }
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List methods) {
    }
}

