/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.proxy.CallbackGenerator;
import cn.taketoday.bytecode.proxy.Dispatcher;
import cn.taketoday.bytecode.proxy.ProxyRefDispatcher;
import java.lang.reflect.Modifier;
import java.util.List;

final class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator(false);
    public static final DispatcherGenerator PROXY_REF_INSTANCE = new DispatcherGenerator(true);
    private static final Type DISPATCHER = Type.fromClass(Dispatcher.class);
    private static final Type PROXY_REF_DISPATCHER = Type.fromClass(ProxyRefDispatcher.class);
    private static final MethodSignature LOAD_OBJECT = MethodSignature.from("Object loadObject()");
    private static final MethodSignature PROXY_REF_LOAD_OBJECT = MethodSignature.from("Object loadObject(Object)");
    private final boolean proxyRef;

    private DispatcherGenerator(boolean proxyRef) {
        this.proxyRef = proxyRef;
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            if (Modifier.isProtected(method.getModifiers())) continue;
            CodeEmitter e = context.beginMethod(ce, method);
            context.emitCallback(e, context.getIndex(method));
            if (this.proxyRef) {
                e.loadThis();
                e.invokeInterface(PROXY_REF_DISPATCHER, PROXY_REF_LOAD_OBJECT);
            } else {
                e.invokeInterface(DISPATCHER, LOAD_OBJECT);
            }
            e.checkCast(method.getClassInfo().getType());
            e.loadArgs();
            e.invoke(method);
            e.returnValue();
            e.end_method();
        }
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List<MethodInfo> methods) throws Exception {
    }
}

