/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.ClassWriter;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.lang.TodayStrategies;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class DebuggingClassWriter
extends ClassVisitor {
    public static final String DEBUG_LOCATION_PROPERTY = "bytecode.debugLocation";
    private static String debugLocation = TodayStrategies.getProperty("bytecode.debugLocation");
    private String className;
    private String superName;

    public DebuggingClassWriter(int flags) {
        super(new ClassWriter(flags));
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.superName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperName() {
        return this.superName;
    }

    public byte[] toByteArray() {
        byte[] b = ((ClassWriter)this.cv).toByteArray();
        if (debugLocation != null) {
            this.debug(b);
        }
        return b;
    }

    public static void setDebugLocation(String debugLocation) {
        DebuggingClassWriter.debugLocation = debugLocation;
    }

    private void debug(byte[] b) {
        this.className = this.className.replace('/', '.');
        this.superName = this.superName.replace('/', '.');
        String dirs = this.className.replace('.', File.separatorChar);
        try {
            new File(debugLocation + File.separatorChar + dirs).getParentFile().mkdirs();
            File file = new File(new File(debugLocation), dirs + ".class");
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                ((OutputStream)out).write(b);
            }
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    static {
        if (debugLocation != null) {
            System.err.println("CGLIB debugging enabled, writing to '" + debugLocation + "'");
        }
    }
}

