/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.GeneratorAdapter;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.Block;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.ClassInfo;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.SimpleMethodInfo;
import java.lang.reflect.Modifier;

public class CodeEmitter
extends GeneratorAdapter {
    private final ClassEmitter ce;
    private final SimpleMethodInfo methodInfo;

    CodeEmitter(ClassEmitter ce, MethodVisitor mv, int access, MethodSignature sig, Type[] exceptionTypes) {
        super(access, sig, mv);
        this.ce = ce;
        this.methodInfo = new SimpleMethodInfo(ce.getClassInfo(), access, sig, exceptionTypes);
    }

    public CodeEmitter(CodeEmitter wrap) {
        super(wrap);
        this.ce = wrap.ce;
        this.methodInfo = wrap.methodInfo;
    }

    public boolean isStaticHook() {
        return false;
    }

    public MethodSignature getSignature() {
        return this.methodInfo.getSignature();
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public ClassEmitter getClassEmitter() {
        return this.ce;
    }

    public void end_method() {
        this.visitMaxs(0, 0);
    }

    public Block begin_block() {
        return new Block(this);
    }

    public void catchException(Block block, Type exception) {
        if (block.getEnd() == null) {
            throw new IllegalStateException("end of block is unset");
        }
        this.mv.visitTryCatchBlock(block.getStart(), block.getEnd(), this.mark(), exception.getInternalName());
    }

    public void getField(String name) {
        ClassEmitter.FieldInfo info = this.ce.getFieldInfo(name);
        int opcode = Modifier.isStatic(info.access) ? 178 : 180;
        this.fieldInsn(opcode, this.ce.getClassType(), name, info.type);
    }

    public void putField(String name) {
        ClassEmitter.FieldInfo info = this.ce.getFieldInfo(name);
        int opcode = Modifier.isStatic(info.access) ? 179 : 181;
        this.fieldInsn(opcode, this.ce.getClassType(), name, info.type);
    }

    public void super_getfield(String name, Type type) {
        this.fieldInsn(180, this.ce.getSuperType(), name, type);
    }

    public void super_putfield(String name, Type type) {
        this.fieldInsn(181, this.ce.getSuperType(), name, type);
    }

    public void super_getstatic(String name, Type type) {
        this.fieldInsn(178, this.ce.getSuperType(), name, type);
    }

    public void super_putstatic(String name, Type type) {
        this.fieldInsn(179, this.ce.getSuperType(), name, type);
    }

    public void super_invoke() {
        this.super_invoke(this.methodInfo.getSignature());
    }

    public void super_invoke(MethodSignature sig) {
        this.invokeInsn(183, this.ce.getSuperType(), sig, false);
    }

    public void super_invoke_constructor() {
        this.invokeConstructor(this.ce.getSuperType());
    }

    public void invoke_constructor_this() {
        this.invokeConstructor(this.ce.getClassType());
    }

    public void invokeStatic(Type owner, MethodSignature sig, boolean isInterface) {
        this.invokeInsn(184, owner, sig, isInterface);
    }

    public void invoke_virtual_this(MethodSignature sig) {
        this.invokeVirtual(this.ce.getClassType(), sig);
    }

    public void invoke_static_this(MethodSignature sig) {
        this.invokeStatic(this.ce.getClassType(), sig);
    }

    public void invoke_constructor_this(MethodSignature sig) {
        this.invokeConstructor(this.ce.getClassType(), sig);
    }

    public void super_invoke_constructor(MethodSignature sig) {
        this.invokeConstructor(this.ce.getSuperType(), sig);
    }

    public void new_instance_this() {
        this.newInstance(this.ce.getClassType());
    }

    public void checkcast_this() {
        this.checkCast(this.ce.getClassType());
    }

    public void instance_of_this() {
        this.instanceOf(this.ce.getClassType());
    }

    public void zero_or_null(Type type) {
        if (type.isPrimitive()) {
            switch (type.getSort()) {
                case 8: {
                    this.push(0.0);
                    break;
                }
                case 7: {
                    this.push(0L);
                    break;
                }
                case 6: {
                    this.push(0.0f);
                    break;
                }
                case 0: {
                    this.aconst_null();
                }
                default: {
                    this.push(0);
                    break;
                }
            }
        } else {
            this.aconst_null();
        }
    }

    public void unbox_or_zero(Type type) {
        if (type.isPrimitive()) {
            if (type != Type.VOID_TYPE) {
                Label nonNull = this.newLabel();
                Label end = this.newLabel();
                this.dup();
                this.ifNonNull(nonNull);
                this.pop();
                this.zero_or_null(type);
                this.goTo(end);
                this.mark(nonNull);
                this.unbox(type);
                this.mark(end);
            }
        } else {
            this.checkCast(type);
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (!Modifier.isAbstract(this.methodInfo.getModifiers())) {
            super.visitMaxs(maxStack, maxLocals);
        }
    }

    public void invoke(MethodInfo method, Type virtualType) {
        ClassInfo classInfo = method.getClassInfo();
        Type type = classInfo.getType();
        MethodSignature sig = method.getSignature();
        if ("<init>".equals(sig.getName())) {
            this.invokeConstructor(type, sig);
        } else if (Modifier.isStatic(method.getModifiers())) {
            this.invokeStatic(type, sig, Modifier.isInterface(classInfo.getModifiers()));
        } else if (Modifier.isInterface(classInfo.getModifiers())) {
            this.invokeInterface(type, sig);
        } else {
            this.invokeVirtual(virtualType, sig);
        }
    }

    public void invoke(MethodInfo method) {
        this.invoke(method, method.getClassInfo().getType());
    }
}

