/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.Type;

public abstract class ClassInfo {
    protected ClassInfo() {
    }

    public abstract Type getType();

    public abstract Type getSuperType();

    public abstract Type[] getInterfaces();

    public abstract int getModifiers();

    public boolean equals(Object o) {
        return o == this || o instanceof ClassInfo && this.getType().equals(((ClassInfo)o).getType());
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        return this.getType().getClassName();
    }

    public static ClassInfo from(final Class clazz) {
        final Type type = Type.fromClass(clazz);
        final Type sc = clazz.getSuperclass() == null ? null : Type.fromClass(clazz.getSuperclass());
        final class DefaultClassInfo
        extends ClassInfo {
            DefaultClassInfo() {
            }

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public Type getSuperType() {
                return sc;
            }

            @Override
            public Type[] getInterfaces() {
                return Type.getTypes(clazz.getInterfaces());
            }

            @Override
            public int getModifiers() {
                return clazz.getModifiers();
            }
        }
        return new DefaultClassInfo();
    }
}

