/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.beans.BeanMap;
import cn.taketoday.bytecode.beans.FixedKeySet;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.ObjectSwitchCallback;
import cn.taketoday.util.StringUtils;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class BeanMapEmitter
extends ClassEmitter {
    private static final Type BEAN_MAP = Type.fromClass(BeanMap.class);
    private static final Type FIXED_KEY_SET = Type.fromClass(FixedKeySet.class);
    private static final MethodSignature CSTRUCT_OBJECT = MethodSignature.forConstructor("Object");
    private static final MethodSignature CSTRUCT_STRING_ARRAY = MethodSignature.forConstructor("String[]");
    private static final MethodSignature BEAN_MAP_GET = MethodSignature.from("Object get(Object, Object)");
    private static final MethodSignature BEAN_MAP_PUT = MethodSignature.from("Object put(Object, Object, Object)");
    private static final MethodSignature KEY_SET = MethodSignature.from("java.util.Set keySet()");
    private static final MethodSignature NEW_INSTANCE = new MethodSignature(BEAN_MAP, "newInstance", Type.TYPE_OBJECT);
    private static final MethodSignature GET_PROPERTY_TYPE = MethodSignature.from("Class getPropertyType(String)");

    public BeanMapEmitter(ClassVisitor v, String className, Class type, int require) {
        super(v);
        this.beginClass(52, 1, className, BEAN_MAP, null, "<cglibGenerated>");
        EmitUtils.nullConstructor(this);
        EmitUtils.factoryMethod(this, NEW_INSTANCE);
        this.generateConstructor();
        Map<String, PropertyDescriptor> getters = this.toMap(CglibReflectUtils.getBeanGetters(type));
        Map<String, PropertyDescriptor> setters = this.toMap(CglibReflectUtils.getBeanSetters(type));
        HashMap<String, PropertyDescriptor> allProps = new HashMap<String, PropertyDescriptor>();
        allProps.putAll(getters);
        allProps.putAll(setters);
        if (require != 0) {
            Iterator it = allProps.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (((require & 1) == 0 || getters.containsKey(name)) && ((require & 2) == 0 || setters.containsKey(name))) continue;
                it.remove();
                getters.remove(name);
                setters.remove(name);
            }
        }
        this.generateGet(type, getters);
        this.generatePut(type, setters);
        String[] allNames = this.getNames(allProps);
        this.generateKeySet(allNames);
        this.generateGetPropertyType(allProps, allNames);
        this.endClass();
    }

    private Map<String, PropertyDescriptor> toMap(PropertyDescriptor[] props) {
        HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor prop : props) {
            names.put(prop.getName(), prop);
        }
        return names;
    }

    private String[] getNames(Map<String, PropertyDescriptor> propertyMap) {
        return StringUtils.toStringArray(propertyMap.keySet());
    }

    private void generateConstructor() {
        CodeEmitter e = this.beginMethod(1, CSTRUCT_OBJECT, new Type[0]);
        e.loadThis();
        e.loadArg(0);
        e.super_invoke_constructor(CSTRUCT_OBJECT);
        e.returnValue();
        e.end_method();
    }

    private void generateGet(Class type, final Map<String, PropertyDescriptor> getters) {
        final CodeEmitter e = this.beginMethod(1, BEAN_MAP_GET, new Type[0]);
        e.loadArg(0);
        e.checkCast(Type.fromClass(type));
        e.loadArg(1);
        e.checkCast(Type.TYPE_STRING);
        EmitUtils.stringSwitch(e, this.getNames(getters), 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                PropertyDescriptor pd = (PropertyDescriptor)getters.get(key);
                MethodInfo method = MethodInfo.from(pd.getReadMethod());
                e.invoke(method);
                e.box(method.getSignature().getReturnType());
                e.returnValue();
            }

            @Override
            public void processDefault() {
                e.aconst_null();
                e.returnValue();
            }
        });
        e.end_method();
    }

    private void generatePut(Class type, final Map<String, PropertyDescriptor> setters) {
        final CodeEmitter e = this.beginMethod(1, BEAN_MAP_PUT, new Type[0]);
        e.loadArg(0);
        e.checkCast(Type.fromClass(type));
        e.loadArg(1);
        e.checkCast(Type.TYPE_STRING);
        EmitUtils.stringSwitch(e, this.getNames(setters), 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                PropertyDescriptor pd = (PropertyDescriptor)setters.get(key);
                if (pd.getReadMethod() == null) {
                    e.aconst_null();
                } else {
                    MethodInfo read = MethodInfo.from(pd.getReadMethod());
                    e.dup();
                    e.invoke(read);
                    e.box(read.getSignature().getReturnType());
                }
                e.swap();
                e.loadArg(2);
                MethodInfo write = MethodInfo.from(pd.getWriteMethod());
                e.unbox(write.getSignature().getArgumentTypes()[0]);
                e.invoke(write);
                e.returnValue();
            }

            @Override
            public void processDefault() {
            }
        });
        e.aconst_null();
        e.returnValue();
        e.end_method();
    }

    private void generateKeySet(String[] allNames) {
        this.declare_field(10, "keys", FIXED_KEY_SET, null);
        CodeEmitter e = this.begin_static();
        e.newInstance(FIXED_KEY_SET);
        e.dup();
        EmitUtils.pushArray(e, allNames);
        e.invokeConstructor(FIXED_KEY_SET, CSTRUCT_STRING_ARRAY);
        e.putField("keys");
        e.returnValue();
        e.end_method();
        e = this.beginMethod(1, KEY_SET, new Type[0]);
        e.loadThis();
        e.getField("keys");
        e.returnValue();
        e.end_method();
    }

    private void generateGetPropertyType(final Map<String, PropertyDescriptor> allProps, String[] allNames) {
        final CodeEmitter e = this.beginMethod(1, GET_PROPERTY_TYPE, new Type[0]);
        e.loadArg(0);
        EmitUtils.stringSwitch(e, allNames, 1, new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                PropertyDescriptor pd = (PropertyDescriptor)allProps.get(key);
                EmitUtils.loadClass(e, Type.fromClass(pd.getPropertyType()));
                e.returnValue();
            }

            @Override
            public void processDefault() {
                e.aconst_null();
                e.returnValue();
            }
        });
        e.end_method();
    }
}

