/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode;

import cn.taketoday.bytecode.AnnotationValueHolder;
import cn.taketoday.bytecode.ByteVector;
import cn.taketoday.bytecode.ClassValueHolder;
import cn.taketoday.bytecode.SymbolTable;

public final class EnumValueHolder
extends AnnotationValueHolder {
    final String name;
    final String descriptor;

    public EnumValueHolder(String descriptor, String name) {
        this.name = name;
        this.descriptor = descriptor;
    }

    @Override
    protected Object getInternal() {
        Object enumClass = ClassValueHolder.fromDescriptor(this.descriptor).read();
        return Enum.valueOf(enumClass, this.name);
    }

    @Override
    public void write(ByteVector annotation, SymbolTable symbolTable) {
        annotation.put12(101, symbolTable.addConstantUtf8(this.descriptor)).putShort(symbolTable.addConstantUtf8(this.name));
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "EnumValueHolder{value='" + this.name + "', descriptor='" + this.descriptor + "'}";
    }
}

