/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LimitQueue<E>
implements Queue<E> {
    private int limit;
    private Queue<E> queue;
    private Lock lock;

    public LimitQueue(int limit) {
        this(limit, null);
    }

    public LimitQueue(int limit, Queue<E> queue) {
        this(limit, queue, null);
    }

    public LimitQueue(int limit, Queue<E> queue, Lock lock) {
        this.limit = limit;
        if (queue == null) {
            queue = new LinkedList();
        }
        this.queue = queue;
        if (lock == null) {
            lock = new ReentrantLock();
        }
        this.lock = lock;
    }

    @Override
    public boolean offer(E e) {
        this.lock.lock();
        if (this.queue.size() >= this.limit) {
            this.queue.poll();
        }
        this.lock.unlock();
        return this.queue.offer(e);
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    public Queue<E> getQueue() {
        return this.queue;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public boolean add(E e) {
        return this.queue.offer(e);
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public E remove() {
        return this.queue.remove();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("unsport");
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return this.queue.equals(o);
    }

    @Override
    public int hashCode() {
        return this.queue.hashCode();
    }

    public String toString() {
        return this.queue.toString();
    }
}

