/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure;

import cn.featherfly.common.lang.Lang;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Groupable<K, V> {
    private V defaultValue;
    private final Map<K, V> groupValues;

    public Groupable(V defaultValue) {
        this(defaultValue, null);
    }

    public Groupable(V defaultValue, Map<K, V> groupValues) {
        this.defaultValue = defaultValue;
        this.groupValues = groupValues == null ? new HashMap(0) : groupValues;
    }

    public Groupable<K, V> addGroup(K group, V value) {
        this.groupValues.put(group, value);
        return this;
    }

    public V removeGroup(Object key) {
        return this.groupValues.remove(key);
    }

    public V getValueByGroup(K group) {
        return this.groupValues.get(group);
    }

    public V getValue(K group) {
        V d = this.getValueByGroup(group);
        if (Lang.isNotEmpty(d)) {
            return d;
        }
        return this.defaultValue;
    }

    public V getValue() {
        return this.defaultValue;
    }

    public boolean containsGroup(K group) {
        return this.groupValues.containsKey(group);
    }

    public boolean containsValue(V value) {
        return this.groupValues.containsValue(value);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.groupValues.entrySet();
    }

    public Set<K> groupSet() {
        return this.groupValues.keySet();
    }

    public Collection<V> values() {
        return this.groupValues.values();
    }
}

