/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.storage.stream;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.UriUtils;
import cn.featherfly.common.storage.DateLocalDirStorage;
import cn.featherfly.common.storage.StorageException;
import cn.featherfly.common.storage.stream.StreamStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class StreamDateLocalDirStorage
extends DateLocalDirStorage<InputStream>
implements StreamStorage {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String store(InputStream is) {
        ASSERT.isNotNull(is, "param InputStream");
        try {
            File targetFile = this.createTargetFile("stream has no name");
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            try (FileOutputStream os = new FileOutputStream(targetFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                String string = this.getId(targetFile);
                return string;
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public InputStream retrieve(String id) {
        File file = this.retrieveFile(id);
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean delete(String id) {
        File file = this.retrieveFile(id);
        return FileUtils.delete(file);
    }

    @Override
    public boolean exists(String id) {
        File file = this.retrieveFile(id);
        return file.exists();
    }

    private File retrieveFile(String id) {
        ASSERT.isNotEmpty(id, "id");
        this.logger.debug("file storage id \uff1a{}", (Object)id);
        File file = this.createRelativeDir();
        file = new File(UriUtils.linkUri(file.getAbsolutePath(), id));
        this.logger.debug("get file\uff1a{}", (Object)file.getAbsolutePath());
        return file;
    }
}

